/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp.thinap.text;

import at.mrdevelopment.toolkit.Version;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.thinap.ResponseCode;
import at.mrdevelopment.toolkit.tcp.thinap.TextConstants;
import at.mrdevelopment.toolkit.tcp.thinap.TextHelper;
import at.mrdevelopment.toolkit.tcp.thinap.ThinAPPacketIdentifier;
import at.mrdevelopment.toolkit.tcp.thinap.text.AbstractKey;
import at.mrdevelopment.toolkit.tcp.thinap.text.IntroductionResponseCode;
import at.mrdevelopment.toolkit.tcp.thinap.text.ThinAPTextPacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.ThinAPTextPacketKind;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class IntroductionResponsePacket
extends ThinAPTextPacket {
    private static ESLLogger logger = ESLLogger.getLogger(IntroductionResponsePacket.class);
    private Byte protocolVersion;
    private Short eslChannel;
    private Integer accessPointId;
    private Version fwVersion;
    private String deviceType;
    private String swVersion;
    private Integer maxWindowSize;
    private IntroductionResponseCode responseCode;

    public IntroductionResponsePacket() {
        super(ThinAPPacketIdentifier.INTRODUCTION_RESPONSE, Key.KEYS);
    }

    @Override
    public void fillWithDataFrom(ByteBuffer inputBuffer) {
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TCPStatusPacket [protocolVersion=");
        builder.append(this.protocolVersion);
        builder.append(", eslChannel=");
        builder.append(this.eslChannel);
        builder.append(", accessPointId=");
        builder.append(this.accessPointId);
        builder.append(", fwVersion=");
        builder.append(String.format("%02X", this.fwVersion));
        builder.append(", deviceType=");
        builder.append(this.deviceType);
        builder.append(", swVersion=");
        builder.append(this.swVersion);
        builder.append(", responseCode=");
        builder.append((Object)this.responseCode);
        builder.append("]");
        return builder.toString();
    }

    public byte[] toBytes() {
        return new byte[0];
    }

    @Override
    public void setTextHeader(String key, String value) {
        Key currentKey = null;
        if (Key.RESPONSE_CODE.getKey().equals(key)) {
            this.responseCode = IntroductionResponseCode.from(value);
            currentKey = Key.RESPONSE_CODE;
            if (this.responseCode == null) {
                this.headerLineFailed();
            }
        } else if (Key.AP_ID.getKey().equals(key)) {
            this.accessPointId = TextHelper.convertToInt(value);
            currentKey = Key.AP_ID;
            if (this.accessPointId == null) {
                this.headerLineFailed();
            }
        } else if (Key.PROTOCOL_VERSION.getKey().equals(key)) {
            this.protocolVersion = TextHelper.convertToByte(value);
            currentKey = Key.PROTOCOL_VERSION;
            if (this.protocolVersion == null) {
                this.headerLineFailed();
            }
        } else if (Key.MAX_WINDOW_SIZE.getKey().equals(key)) {
            this.maxWindowSize = TextHelper.convertToInt(value);
            currentKey = Key.MAX_WINDOW_SIZE;
            if (this.maxWindowSize == null) {
                this.headerLineFailed();
            }
        } else if (Key.ESL_CHANNEL.getKey().equals(key)) {
            this.eslChannel = TextHelper.convertToShort(value);
            currentKey = Key.ESL_CHANNEL;
            if (this.eslChannel == null) {
                this.headerLineFailed();
            }
        } else if (Key.FIRMWARE.getKey().equals(key)) {
            Version version = Version.fromStringIgnoreBranch(value);
            currentKey = Key.FIRMWARE;
            if (version == null) {
                this.headerLineFailed();
            } else {
                this.fwVersion = version;
            }
        } else if (Key.DEVICE_TYPE.getKey().equals(key)) {
            this.deviceType = value;
            currentKey = Key.DEVICE_TYPE;
            if (this.deviceType == null) {
                this.headerLineFailed();
            }
        } else if (Key.SOFTWARE.getKey().equals(key)) {
            this.swVersion = value;
            currentKey = Key.SOFTWARE;
            if (this.swVersion == null) {
                this.headerLineFailed();
            }
        } else {
            logger.info("Introduction packet contained header '%s' with value '%s' which was not parsed.", key, value);
        }
        if (currentKey != null) {
            this.fieldSet.set(currentKey.idx, true);
        }
    }

    public Byte getProtocolVersion() {
        return this.protocolVersion;
    }

    public Short getEslChannel() {
        return this.eslChannel;
    }

    public Integer getAccessPointId() {
        return this.accessPointId;
    }

    public Version getFwVersion() {
        return this.fwVersion;
    }

    public String getDeviceType() {
        return this.deviceType;
    }

    public String getSwVersion() {
        return this.swVersion;
    }

    public Integer getMaxWindowSize() {
        return this.maxWindowSize;
    }

    public IntroductionResponseCode getResponseCode() {
        return this.responseCode;
    }

    public static byte[] createSuccess(int apId, int eslChannel) {
        StringBuffer stb = new StringBuffer(256);
        stb.append((Object)ThinAPTextPacketKind.RESPONSE).append("\r\n");
        TextHelper.addHeader(stb, "Message-Type", "Introduction");
        TextHelper.addHeader(stb, "Response-Code", ResponseCode.SUCCESS.getText());
        TextHelper.addHeader(stb, "Ap-Id", apId);
        TextHelper.addHeader(stb, "Protocol-Version", 2);
        TextHelper.addHeader(stb, "Max-Window-Size", 14);
        TextHelper.addHeader(stb, "Esl-Channel", eslChannel);
        TextHelper.addHeader(stb, "Firmware", new Version(3, 0, 9, 2713, "").toString());
        TextHelper.addHeader(stb, "Device-Type", "Imagotag AP-2010");
        TextHelper.addHeader(stb, "Software", new Version(1, 0, 0, 134, "").toString());
        stb.append("\r\n");
        byte[] messageData = stb.toString().getBytes(TextConstants.ENCODING);
        return messageData;
    }

    public static byte[] createError(ResponseCode responseCode) {
        StringBuffer stb = new StringBuffer(256);
        stb.append((Object)ThinAPTextPacketKind.RESPONSE).append("\r\n");
        TextHelper.addHeader(stb, "Message-Type", "Introduction");
        TextHelper.addHeader(stb, "Response-Code", responseCode.getText());
        stb.append("\r\n");
        byte[] messageData = stb.toString().getBytes(TextConstants.ENCODING);
        return messageData;
    }

    private static class Key
    extends AbstractKey {
        private static final List<AbstractKey> KEYS = new ArrayList<AbstractKey>(7);
        static final Key RESPONSE_CODE = new Key("Response-Code");
        static final Key AP_ID = new Key("Ap-Id");
        static final Key PROTOCOL_VERSION = new Key("Protocol-Version");
        static final Key MAX_WINDOW_SIZE = new Key("Max-Window-Size");
        static final Key ESL_CHANNEL = new Key("Esl-Channel");
        static final Key FIRMWARE = new Key("Firmware");
        static final Key DEVICE_TYPE = new Key("Device-Type");
        static final Key SOFTWARE = new Key("Software");

        protected Key(String key) {
            super(key);
            KEYS.add(this);
        }

        @Override
        public int getNextIdx() {
            return KEYS.size();
        }
    }
}

