/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp.thinap.text;

import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.thinap.CommunicationChannelType;
import at.mrdevelopment.toolkit.tcp.thinap.TextConstants;
import at.mrdevelopment.toolkit.tcp.thinap.TextHelper;
import at.mrdevelopment.toolkit.tcp.thinap.ThinAPPacketIdentifier;
import at.mrdevelopment.toolkit.tcp.thinap.text.AbstractKey;
import at.mrdevelopment.toolkit.tcp.thinap.text.ThinAPTextPacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.ThinAPTextPacketKind;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;

public class IntroductionRequestPacket
extends ThinAPTextPacket {
    private static ESLLogger logger = ESLLogger.getLogger(IntroductionRequestPacket.class);
    private Byte protocolVersion;
    private CommunicationChannelType channelType;
    private int apId = -1;

    public IntroductionRequestPacket() {
        super(ThinAPPacketIdentifier.INTRODUCTION_REQUEST, Key.KEYS);
    }

    @Override
    public void fillWithDataFrom(ByteBuffer inputBuffer) {
    }

    @Override
    public void setTextHeader(String key, String value) {
        Key currentKey = null;
        if (Key.PROTOCOL_VERSION.getKey().equals(key)) {
            this.protocolVersion = TextHelper.convertToByte(value);
            currentKey = Key.PROTOCOL_VERSION;
            if (this.protocolVersion == null) {
                this.headerLineFailed();
            }
        } else if (Key.CHANNEL_TYPE.getKey().equals(key)) {
            this.channelType = CommunicationChannelType.from(value);
            currentKey = Key.CHANNEL_TYPE;
            if (this.channelType == CommunicationChannelType.UNKNOWN) {
                this.headerLineFailed();
            }
        } else if (Key.AP_ID.getKey().equals(key)) {
            this.apId = -1;
            this.apId = TextHelper.convertToInt(value);
            currentKey = Key.AP_ID;
            if (this.apId <= 0) {
                this.headerLineFailed();
            }
        } else {
            logger.info("Introduction packet contained header '%s' with value '%s' which was not parsed.", key, value);
        }
        if (currentKey != null) {
            this.fieldSet.set(currentKey.idx, true);
        }
    }

    public short getProtocolVersion() {
        return this.protocolVersion.byteValue();
    }

    public CommunicationChannelType getChannelType() {
        return this.channelType;
    }

    public int getApId() {
        return this.apId;
    }

    public static byte[] create(CommunicationChannelType channelType, int apId) {
        StringBuffer stb = new StringBuffer(128);
        stb.append((Object)ThinAPTextPacketKind.REQUEST).append("\r\n");
        TextHelper.addHeader(stb, "Message-Type", "Introduction");
        TextHelper.addHeader(stb, "Protocol-Version", 2);
        TextHelper.addHeader(stb, "Channel-Type", channelType.getText());
        TextHelper.addHeader(stb, "Ap-Id", Integer.toString(apId));
        stb.append("\r\n");
        byte[] messageData = stb.toString().getBytes(TextConstants.ENCODING);
        return messageData;
    }

    private static class Key
    extends AbstractKey {
        private static final List<AbstractKey> KEYS = new ArrayList<AbstractKey>(2);
        static final Key PROTOCOL_VERSION = new Key("Protocol-Version");
        static final Key CHANNEL_TYPE = new Key("Channel-Type");
        static final Key AP_ID = new Key("Ap-Id");

        protected Key(String key) {
            super(key);
            KEYS.add(this);
        }

        @Override
        public int getNextIdx() {
            return KEYS.size();
        }
    }
}

