/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp.thinap.text;

import at.mrdevelopment.toolkit.tcp.thinap.text.InfoData;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class InfoDataCache {
    private final Map<String, InfoData> infos = new TreeMap<String, InfoData>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void infoReceived(String category, String key, Iterable<String> values) {
        Map<String, InfoData> map = this.infos;
        synchronized (map) {
            InfoData info = this.infos.containsKey(category) ? this.infos.get(category) : new InfoData(category);
            info.addValue(key, values);
            this.infos.put(category, info);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<InfoData> getInfos() {
        Map<String, InfoData> map = this.infos;
        synchronized (map) {
            return Collections.unmodifiableCollection(Lists.newArrayList(this.infos.values()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getValues(String category, String key) {
        Map<String, InfoData> map = this.infos;
        synchronized (map) {
            InfoData infoData = this.infos.get(category);
            return infoData != null ? infoData.getEntries().get(key) : null;
        }
    }

    public void mergeCache(InfoDataCache newCache) {
        for (Map.Entry<String, InfoData> entry : newCache.infos.entrySet()) {
            InfoData temp = this.infos.get(entry.getKey());
            if (temp == null) {
                temp = new InfoData(entry.getKey());
                this.infos.put(entry.getKey(), temp);
            }
            for (Map.Entry<String, List<String>> newEntries : entry.getValue().getEntries().entrySet()) {
                temp.addValue(newEntries.getKey(), (Iterable<String>)newEntries.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        Map<String, InfoData> map = this.infos;
        synchronized (map) {
            this.infos.clear();
        }
    }

    public String toString() {
        return Joiner.on((String)"|").withKeyValueSeparator("=").join(this.infos);
    }
}

