/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp.thinap.text;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class InfoData {
    private final String infoCategory;
    private final Map<String, List<String>> values = new LinkedHashMap<String, List<String>>();

    public InfoData(String infoCategory) {
        this.infoCategory = infoCategory;
    }

    public String getInfoCategory() {
        return this.infoCategory;
    }

    public void addValue(String key, Iterable<String> values) {
        this.values.put(key, Lists.newArrayList(values));
    }

    public void addValue(String key, String value) {
        if (!this.values.containsKey(key)) {
            this.values.put(key, new ArrayList());
        }
        this.values.get(key).add(value);
    }

    public void clear() {
        this.values.clear();
    }

    public void removeEntry(String key) {
        this.values.remove(key);
    }

    public Map<String, List<String>> getEntries() {
        return Collections.unmodifiableMap(this.values);
    }

    public String toString() {
        return String.format("%s: %s", Joiner.on((String)",").withKeyValueSeparator("=").join(this.values));
    }
}

