/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp.thinap.text;

import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.thinap.ResponseCode;
import at.mrdevelopment.toolkit.tcp.thinap.TextConstants;
import at.mrdevelopment.toolkit.tcp.thinap.TextHelper;
import at.mrdevelopment.toolkit.tcp.thinap.ThinAPPacketIdentifier;
import at.mrdevelopment.toolkit.tcp.thinap.text.AbstractKey;
import at.mrdevelopment.toolkit.tcp.thinap.text.ConfigResponseCode;
import at.mrdevelopment.toolkit.tcp.thinap.text.Feature;
import at.mrdevelopment.toolkit.tcp.thinap.text.ThinAPTextPacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.ThinAPTextPacketKind;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ConfigurationResponsePacket
extends ThinAPTextPacket {
    private static ESLLogger logger = ESLLogger.getLogger(ConfigurationResponsePacket.class);
    private static final Key FEATURE = new Key("Feature", true);
    private ConfigResponseCode responseCode;
    private Integer initialSlot;
    private final Set<Feature> featureSet = new HashSet<Feature>();

    public ConfigurationResponsePacket() {
        super(ThinAPPacketIdentifier.CONFIGURATION_RESPONSE, Key.KEYS);
    }

    @Override
    public void setTextHeader(String key, String value) {
        Key currentKey = null;
        if (Key.RESPONSE_CODE.getKey().equals(key)) {
            this.responseCode = ConfigResponseCode.from(value);
            currentKey = Key.RESPONSE_CODE;
            if (this.responseCode == null) {
                this.headerLineFailed();
            }
        } else if (Key.INITIAL_SLOT.getKey().equals(key)) {
            this.initialSlot = TextHelper.convertToIntFromHex(value);
            currentKey = Key.INITIAL_SLOT;
            if (this.initialSlot == null) {
                this.headerLineFailed();
            }
        } else if (FEATURE.getKey().equals(key)) {
            Feature feature = Feature.from(value);
            currentKey = FEATURE;
            if (feature == null) {
                this.headerLineFailed();
            } else {
                this.featureSet.add(feature);
            }
        } else {
            logger.info("Configuration packet contained header '%s' with value '%s' which was not parsed.", key, value);
        }
        if (currentKey != null) {
            this.fieldSet.set(currentKey.idx, true);
        }
    }

    public ConfigResponseCode getResponseCode() {
        return this.responseCode;
    }

    public Integer getInitialSlot() {
        return this.initialSlot;
    }

    public static byte[] createSuccess(int initialSlot, Set<Feature> useableFeatures) {
        StringBuffer stb = new StringBuffer(128);
        stb.append((Object)ThinAPTextPacketKind.RESPONSE).append("\r\n");
        TextHelper.addHeader(stb, "Message-Type", "Configuration");
        TextHelper.addHeader(stb, "Response-Code", ResponseCode.SUCCESS.getText());
        TextHelper.addHeader(stb, "Initial-Slot", String.format("%02X", initialSlot));
        for (Feature feature : useableFeatures) {
            TextHelper.addHeader(stb, "Feature", feature.getText());
        }
        stb.append("\r\n");
        byte[] messageData = stb.toString().getBytes(TextConstants.ENCODING);
        return messageData;
    }

    public static byte[] createError() {
        StringBuffer stb = new StringBuffer(128);
        stb.append((Object)ThinAPTextPacketKind.RESPONSE).append("\r\n");
        TextHelper.addHeader(stb, "Message-Type", "Configuration");
        TextHelper.addHeader(stb, "Response-Code", ResponseCode.ERROR.getText());
        stb.append("\r\n");
        byte[] messageData = stb.toString().getBytes(TextConstants.ENCODING);
        return messageData;
    }

    public Set<Feature> getFeatureSet() {
        return Collections.unmodifiableSet(this.featureSet);
    }

    private static class Key
    extends AbstractKey {
        private static final List<AbstractKey> KEYS = new ArrayList<AbstractKey>(2);
        static final Key RESPONSE_CODE = new Key("Response-Code");
        static final Key INITIAL_SLOT = new Key("Initial-Slot");

        protected Key(String key) {
            super(key);
            KEYS.add(this);
        }

        protected Key(String key, boolean optional) {
            super(key, optional);
            KEYS.add(this);
        }

        @Override
        public int getNextIdx() {
            return KEYS.size();
        }
    }
}

