/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp.thinap.text;

import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.thinap.TextConstants;
import at.mrdevelopment.toolkit.tcp.thinap.TextHelper;
import at.mrdevelopment.toolkit.tcp.thinap.ThinAPPacketIdentifier;
import at.mrdevelopment.toolkit.tcp.thinap.text.AbstractKey;
import at.mrdevelopment.toolkit.tcp.thinap.text.Feature;
import at.mrdevelopment.toolkit.tcp.thinap.text.ThinAPTextPacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.ThinAPTextPacketKind;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ConfigurationRequestPacket
extends ThinAPTextPacket {
    private static ESLLogger logger = ESLLogger.getLogger(ConfigurationRequestPacket.class);
    private final Set<Feature> featureSet = new HashSet<Feature>();
    private static final Key FEATURE = new Key("Feature", true);

    public ConfigurationRequestPacket() {
        super(ThinAPPacketIdentifier.CONFIGURATION_REQUEST, Key.KEYS);
    }

    @Override
    public void fillWithDataFrom(ByteBuffer inputBuffer) {
    }

    @Override
    public void setTextHeader(String key, String value) {
        Key currentKey = null;
        if (FEATURE.getKey().equals(key)) {
            Feature feature = Feature.from(value);
            currentKey = FEATURE;
            if (feature == null) {
                this.headerLineFailed();
            } else {
                this.featureSet.add(feature);
            }
        } else {
            logger.info("Configuration packet contained header '%s' with value '%s' which was not parsed.", key, value);
        }
        if (currentKey != null) {
            this.fieldSet.set(currentKey.idx, true);
        }
    }

    public byte[] toBytes() {
        StringBuffer stb = new StringBuffer(2048);
        stb.append((Object)ThinAPTextPacketKind.REQUEST).append("\r\n");
        TextHelper.addHeader(stb, "Message-Type", "Configuration");
        stb.append("\r\n");
        byte[] messageData = stb.toString().getBytes(TextConstants.ENCODING);
        return messageData;
    }

    public static byte[] create() {
        StringBuffer stb = new StringBuffer(128);
        stb.append((Object)ThinAPTextPacketKind.REQUEST).append("\r\n");
        TextHelper.addHeader(stb, "Message-Type", "Configuration");
        TextHelper.addHeader(stb, "Feature", "Empty-Sync-Optimization");
        TextHelper.addHeader(stb, "Feature", "Data-Transmission-Allow-Join");
        stb.append("\r\n");
        byte[] messageData = stb.toString().getBytes(TextConstants.ENCODING);
        return messageData;
    }

    public Set<Feature> getFeatureSet() {
        return Collections.unmodifiableSet(this.featureSet);
    }

    private static class Key
    extends AbstractKey {
        private static final List<AbstractKey> KEYS = new ArrayList<AbstractKey>(2);

        protected Key(String key, boolean optional) {
            super(key, optional);
            KEYS.add(this);
        }

        @Override
        public int getNextIdx() {
            return KEYS.size();
        }
    }
}

