/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp.thinap.text;

import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.thinap.TextHelper;
import at.mrdevelopment.toolkit.tcp.thinap.ThinAPPacketIdentifier;
import at.mrdevelopment.toolkit.tcp.thinap.text.AbstractKey;
import at.mrdevelopment.toolkit.tcp.thinap.text.ConfigResponseCode;
import at.mrdevelopment.toolkit.tcp.thinap.text.ThinAPTextPacket;
import java.util.ArrayList;
import java.util.List;

public class ConfigUpdateResponsePacket
extends ThinAPTextPacket {
    private static ESLLogger logger = ESLLogger.getLogger(ConfigUpdateResponsePacket.class);
    private ConfigResponseCode responseCode;
    private String[] parseErrorFields;
    private String[] updateErrorFields;

    public ConfigUpdateResponsePacket() {
        super(ThinAPPacketIdentifier.CONFIG_UPDATE_RESPONSE, Key.KEYS);
    }

    @Override
    public void setTextHeader(String key, String value) {
        Key currentKey = null;
        if (Key.RESPONSE_CODE.getKey().equals(key)) {
            this.responseCode = ConfigResponseCode.from(value);
            currentKey = Key.RESPONSE_CODE;
            if (this.responseCode == null) {
                this.headerLineFailed();
            }
        } else if (Key.PARSE_ERROR_FIELDS.getKey().equals(key)) {
            this.parseErrorFields = TextHelper.splitUp(value);
            currentKey = Key.PARSE_ERROR_FIELDS;
            if (this.parseErrorFields == null) {
                this.headerLineFailed();
            }
        } else if (Key.UPDATE_ERROR_FIELDS.getKey().equals(key)) {
            this.updateErrorFields = TextHelper.splitUp(value);
            currentKey = Key.UPDATE_ERROR_FIELDS;
            if (this.updateErrorFields == null) {
                this.headerLineFailed();
            }
        } else {
            logger.info("Configuration packet contained header '%s' with value '%s' which was not parsed.", key, value);
        }
        if (currentKey != null) {
            this.fieldSet.set(currentKey.idx, true);
        }
    }

    public ConfigResponseCode getResponseCode() {
        return this.responseCode;
    }

    public String[] getParseErrorFields() {
        String[] stringArray;
        if (this.parseErrorFields != null) {
            stringArray = this.parseErrorFields;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "none";
        }
        return stringArray;
    }

    public String[] getUpdateErrorFields() {
        String[] stringArray;
        if (this.updateErrorFields != null) {
            stringArray = this.updateErrorFields;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "none";
        }
        return stringArray;
    }

    private static class Key
    extends AbstractKey {
        private static final List<AbstractKey> KEYS = new ArrayList<AbstractKey>(3);
        static final Key RESPONSE_CODE = new Key("Response-Code");
        static final Key PARSE_ERROR_FIELDS = new Key("Parse-Error-Fields", true);
        static final Key UPDATE_ERROR_FIELDS = new Key("Update-Error-Fields", true);

        protected Key(String key) {
            super(key);
            KEYS.add(this);
        }

        protected Key(String key, boolean optional) {
            super(key, optional);
            KEYS.add(this);
        }

        @Override
        public int getNextIdx() {
            return KEYS.size();
        }
    }
}

