/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp.thinap.text;

import at.mrdevelopment.toolkit.tcp.thinap.ThinAPPacketIdentifier;
import at.mrdevelopment.toolkit.tcp.thinap.text.AbstractKey;
import at.mrdevelopment.toolkit.tcp.thinap.text.InfoData;
import at.mrdevelopment.toolkit.tcp.thinap.text.InfoDataCache;
import at.mrdevelopment.toolkit.tcp.thinap.text.ThinAPTextPacket;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public abstract class AbstractInfoPacket
extends ThinAPTextPacket {
    private static final String GENERAL_CATEGORY = "GENERAL";
    protected InfoDataCache cache = new InfoDataCache();

    public AbstractInfoPacket(ThinAPPacketIdentifier identifier) {
        super(identifier, new ArrayList<AbstractKey>());
    }

    @Override
    public void setTextHeader(String key, String value) {
        String[] split = StringUtils.split((String)key, (String)"_");
        String category = split.length > 1 ? split[0] : GENERAL_CATEGORY;
        String parsedKey = split.length > 1 ? split[1] : key;
        Iterable values = Splitter.on((String)", ").split((CharSequence)value);
        this.cache.infoReceived(category, parsedKey, values);
    }

    public String getControllerAddress() {
        List<String> values = this.cache.getValues(GENERAL_CATEGORY, "Controller");
        return values != null ? values.iterator().next() : null;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    public Collection<InfoData> getInfos() {
        return this.cache.getInfos();
    }

    public void mergeCache(InfoDataCache newCache) {
        this.cache.mergeCache(newCache);
    }

    public void clearCache() {
        this.cache.clearCache();
    }

    public InfoDataCache getCache() {
        return this.cache;
    }
}

