/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp.thinap;

import at.mrdevelopment.toolkit.tcp.thinap.DataBlock;
import at.mrdevelopment.toolkit.tcp.thinap.ThinAPPacket;
import at.mrdevelopment.toolkit.tcp.thinap.ThinAPPacketIdentifier;
import at.mrdevelopment.toolkit.tcp.thinap.text.Feature;
import java.nio.ByteBuffer;
import java.util.Set;

public class ThinAPSyncPacket
extends ThinAPPacket {
    private static final int SYNC_PACKET_EMPTY_FLAG_LENGTH = 6;
    private boolean commRestartReply;
    private int firstSlotId;
    private short slotCount;
    private byte[][] syncs;
    private DataBlock[] syncDatas;
    private boolean[] joinAllowedFlag;

    protected ThinAPSyncPacket(Set<Feature> features) {
        super(ThinAPPacketIdentifier.SYNC, features);
    }

    @Override
    public void fillWithDataFrom(ByteBuffer inputBuffer) {
        int idx;
        this.commRestartReply = this.getUnsignedByte(inputBuffer) == 1;
        this.firstSlotId = this.getUnsignedShort(inputBuffer);
        this.slotCount = this.getUnsignedByte(inputBuffer);
        int syncLengthInBytes = this.getUnsignedShort(inputBuffer);
        boolean emptySyncOptimizationEnabled = this.features.contains((Object)Feature.EMPTY_SYNC_OPTIMIZATION);
        boolean joinAllowedFlagSet = this.features.contains((Object)Feature.JOIN_ALLOWED_FLAG);
        int syncSendMask = 0;
        int emptySyncJoinMask = 0;
        boolean syncMaskSet = false;
        if (emptySyncOptimizationEnabled) {
            boolean bl = syncMaskSet = (syncLengthInBytes & 1) == 1;
            if (syncMaskSet) {
                syncSendMask = this.getUnsignedShort(inputBuffer);
                if (joinAllowedFlagSet) {
                    emptySyncJoinMask = this.getUnsignedShort(inputBuffer);
                }
            }
            syncLengthInBytes >>= 6;
        }
        this.syncs = new byte[this.slotCount][];
        this.joinAllowedFlag = new boolean[this.slotCount];
        for (idx = 0; idx < this.slotCount; ++idx) {
            boolean readSync;
            byte[] syncData = null;
            boolean bl = emptySyncOptimizationEnabled && syncMaskSet ? ((long)syncSendMask & 1L << idx) != 0L : (readSync = true);
            if (readSync) {
                syncData = new byte[syncLengthInBytes];
                inputBuffer.get(syncData);
            } else if (joinAllowedFlagSet) {
                this.joinAllowedFlag[idx] = ((long)emptySyncJoinMask & 1L << idx) == 1L;
            }
            this.syncs[idx] = syncData;
        }
        this.syncDatas = new DataBlock[this.getUnsignedByte(inputBuffer)];
        for (idx = 0; idx < this.syncDatas.length; ++idx) {
            short slotOffset = this.getUnsignedByte(inputBuffer);
            byte[] data = new byte[inputBuffer.getInt()];
            inputBuffer.get(data);
            this.syncDatas[idx] = new DataBlock(this.firstSlotId + slotOffset, data);
        }
    }

    public boolean isCommRestartReply() {
        return this.commRestartReply;
    }

    public short getSlotCount() {
        return this.slotCount;
    }

    public int getFirstSlotId() {
        return this.firstSlotId;
    }

    public byte[] getSync(int idx) {
        return this.syncs[idx];
    }

    public DataBlock[] getDataBlocks() {
        return this.syncDatas;
    }

    public boolean isJoinAllowed(int idx) {
        return this.joinAllowedFlag[idx];
    }
}

