/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp.thinap;

import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.thinap.ThinAPPacket;
import at.mrdevelopment.toolkit.tcp.thinap.ThinAPPacketIdentifier;
import at.mrdevelopment.toolkit.tcp.thinap.text.Feature;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Collections;
import java.util.Set;

public class ThinAPReplyPacket
extends ThinAPPacket {
    static ESLLogger logger = ESLLogger.getLogger(ThinAPReplyPacket.class);
    private static final int REPLY_PACKET_EMPTY_FLAG_LENGTH = 6;
    private boolean restartSlotSet;
    private int restartSlotId;
    private int firstSlotId;
    private int slotReplyLength;
    private byte[][] replyData;
    private int replyIdx = 0;

    protected ThinAPReplyPacket(Set<Feature> features) {
        super(ThinAPPacketIdentifier.REPLY, features);
    }

    protected ThinAPReplyPacket(int numReplies) {
        super(ThinAPPacketIdentifier.REPLY, Collections.<Feature>emptySet());
        this.replyData = new byte[numReplies][];
    }

    @Override
    public void fillWithDataFrom(ByteBuffer inputBuffer) {
        this.firstSlotId = inputBuffer.getShort();
        int slotReplyCount = this.getUnsignedByte(inputBuffer);
        this.restartSlotSet = this.getUnsignedByte(inputBuffer) == 1;
        this.restartSlotId = inputBuffer.getShort();
        this.slotReplyLength = this.getUnsignedShort(inputBuffer);
        boolean emptySyncOptimizationEnabled = this.features.contains((Object)Feature.EMPTY_SYNC_OPTIMIZATION);
        int requestMask = 0;
        boolean requestMaskSet = false;
        if (emptySyncOptimizationEnabled) {
            boolean bl = requestMaskSet = (this.slotReplyLength & 1) == 1;
            if (requestMaskSet) {
                requestMask = this.getUnsignedShort(inputBuffer);
            }
            this.slotReplyLength >>= 6;
        }
        this.replyData = new byte[slotReplyCount][this.slotReplyLength];
        for (int idx = 0; idx < slotReplyCount; ++idx) {
            boolean readReply;
            boolean bl = emptySyncOptimizationEnabled && requestMaskSet ? ((long)requestMask & 1L << idx) != 0L : (readReply = true);
            if (!readReply) continue;
            byte[] tempArray = this.replyData[idx];
            inputBuffer.get(tempArray);
        }
    }

    public int getFirstSlotId() {
        return this.firstSlotId;
    }

    public boolean isRestartSlotSet() {
        return this.restartSlotSet;
    }

    public int getRestartSlotId() {
        return this.restartSlotId;
    }

    public int getSlotReplyCount() {
        return this.replyData.length;
    }

    public int getSlotReplyLength() {
        return this.slotReplyLength;
    }

    public byte[] getReplyDataById(int slotId) {
        return this.replyData[slotId - this.firstSlotId];
    }

    public byte[] getReplyDataByIdx(int idx) {
        return this.replyData[idx];
    }

    public static ThinAPReplyPacket createEmptyWith(int numReplies) {
        return new ThinAPReplyPacket(numReplies);
    }

    public void setFirstSlotId(int firstSlotId) {
        this.firstSlotId = firstSlotId;
    }

    public void setSlotReplyLength(int slotReplyLength) {
        this.slotReplyLength = slotReplyLength;
    }

    public void addReplyData(byte[] data) {
        if (this.replyIdx < this.replyData.length) {
            this.replyData[this.replyIdx++] = data;
        }
    }

    public byte[] toBytes() {
        int packetLength = this.slotReplyLength * this.replyData.length + 6;
        ByteBuffer buffer = ByteBuffer.allocate(packetLength + 4);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        buffer.putInt(packetLength);
        buffer.put(this.getType().header());
        buffer.putShort((short)this.firstSlotId);
        buffer.put((byte)this.replyData.length);
        buffer.putShort((short)this.slotReplyLength);
        for (int idx = 0; idx < this.replyData.length; ++idx) {
            buffer.put(this.replyData[idx], 0, this.replyData[idx].length);
        }
        byte[] temp = buffer.array();
        if (logger.isDebugEnabled()) {
            logger.debug("Replay Packet: length = %d, array.length = %d", packetLength, temp.length);
        }
        return temp;
    }
}

