/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp.thinap;

import at.mrdevelopment.toolkit.tcp.thinap.ThinAPPacketKind;
import at.mrdevelopment.toolkit.tcp.thinap.text.ThinAPTextPacketKind;

public enum ThinAPPacketIdentifier {
    OUTBOUND_INTRODUCTION_REQUEST(ThinAPTextPacketKind.REQUEST, "Introduction"),
    OUTBOUND_INTRODUCTION_RESPONSE(ThinAPTextPacketKind.RESPONSE, "Introduction"),
    INTRODUCTION_REQUEST(ThinAPTextPacketKind.REQUEST, "Introduction"),
    INTRODUCTION_RESPONSE(ThinAPTextPacketKind.RESPONSE, "Introduction"),
    CONFIGURATION_REQUEST(ThinAPTextPacketKind.REQUEST, "Configuration"),
    CONFIGURATION_RESPONSE(ThinAPTextPacketKind.RESPONSE, "Configuration"),
    CONFIG_UPDATE_REQUEST(ThinAPTextPacketKind.REQUEST, "Config-Update"),
    CONFIG_UPDATE_RESPONSE(ThinAPTextPacketKind.RESPONSE, "Config-Update"),
    INFO(ThinAPTextPacketKind.ONE_WAY, "Info"),
    EXTENDED_INFO(ThinAPTextPacketKind.ONE_WAY, "Extended-Info"),
    ALIVE_PING(ThinAPTextPacketKind.ONE_WAY, "Alive-Ping"),
    SYNC(3),
    REPLY(4),
    UPDATE(5),
    UNKNOWN(255);

    private final ThinAPPacketKind packetKind;
    private final byte header;
    private final ThinAPTextPacketKind textPacketKind;
    private final String textMessage;

    private ThinAPPacketIdentifier(int header) {
        this.packetKind = ThinAPPacketKind.BINARY;
        this.header = (byte)header;
        this.textPacketKind = ThinAPTextPacketKind.REQUEST;
        this.textMessage = "";
    }

    private ThinAPPacketIdentifier(ThinAPTextPacketKind textPacketKind, String textMessage) {
        this.packetKind = ThinAPPacketKind.TEXT;
        this.header = 0;
        this.textPacketKind = textPacketKind;
        this.textMessage = textMessage;
    }

    public byte header() {
        return this.header;
    }

    public ThinAPPacketKind packetKind() {
        return this.packetKind;
    }

    public ThinAPTextPacketKind textPacketKind() {
        return this.textPacketKind;
    }

    public String messageType() {
        return this.textMessage;
    }

    public boolean isBinary() {
        return this.packetKind == ThinAPPacketKind.BINARY;
    }

    public static ThinAPPacketIdentifier from(byte header) {
        ThinAPPacketIdentifier type;
        switch (header) {
            case 3: {
                type = SYNC;
                break;
            }
            case 4: {
                type = REPLY;
                break;
            }
            case 5: {
                type = UPDATE;
                break;
            }
            default: {
                type = UNKNOWN;
            }
        }
        return type;
    }
}

