/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp.thinap;

import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.TCPPacket;
import at.mrdevelopment.toolkit.tcp.thinap.ThinAPPacketIdentifier;
import at.mrdevelopment.toolkit.tcp.thinap.ThinAPReplyPacket;
import at.mrdevelopment.toolkit.tcp.thinap.ThinAPSyncPacket;
import at.mrdevelopment.toolkit.tcp.thinap.ThinAPUnknownBinaryPacket;
import at.mrdevelopment.toolkit.tcp.thinap.ThinAPUpdatePacket;
import at.mrdevelopment.toolkit.tcp.thinap.text.Feature;
import java.nio.ByteBuffer;
import java.util.Set;

public abstract class ThinAPPacket
extends TCPPacket {
    private static ESLLogger logger = ESLLogger.getLogger(ThinAPPacket.class);
    private ThinAPPacketIdentifier type;
    protected final Set<Feature> features;

    protected ThinAPPacket(ThinAPPacketIdentifier type, Set<Feature> features) {
        this.type = type;
        this.features = features;
    }

    public ThinAPPacketIdentifier getType() {
        return this.type;
    }

    public boolean isValid() {
        return false;
    }

    public void setTextHeader(String key, String value) {
    }

    @Override
    public void fillWithDataFrom(ByteBuffer inputBuffer) {
    }

    public static ThinAPPacket decode(ByteBuffer inputBuffer, int bytesForPacket, Set<Feature> features) {
        ThinAPPacket packet = null;
        int positionBeforeProcessing = inputBuffer.position();
        ThinAPPacketIdentifier type = ThinAPPacketIdentifier.from(inputBuffer.get());
        switch (type) {
            case REPLY: {
                packet = new ThinAPReplyPacket(features);
                packet.fillWithDataFrom(inputBuffer);
                break;
            }
            case SYNC: {
                packet = new ThinAPSyncPacket(features);
                packet.fillWithDataFrom(inputBuffer);
                break;
            }
            case UPDATE: {
                packet = new ThinAPUpdatePacket(features);
                packet.fillWithDataFrom(inputBuffer);
            }
            default: {
                packet = new ThinAPUnknownBinaryPacket(features);
                ((ThinAPUnknownBinaryPacket)packet).consume(inputBuffer, bytesForPacket - 1);
                logger.info("Got unrecognized packet.");
            }
        }
        int diff = bytesForPacket - (inputBuffer.position() - positionBeforeProcessing);
        if (diff != 0) {
            logger.error("Did not handle all packet data for = %s, diff = %d", packet.type.name(), diff);
            if (diff > 0) {
                inputBuffer.position(inputBuffer.position() + diff);
            }
        }
        return packet;
    }
}

