/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp.thinap;

import at.mrdevelopment.toolkit.log.ESLLogger;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public class TextHelper {
    static ESLLogger logger = ESLLogger.getLogger(TextHelper.class);

    public static void addHeader(StringBuffer stb, String key, String value) {
        stb.append(key).append(": ").append(value).append("\r\n");
    }

    public static void addHeader(StringBuffer stb, String key, int value) {
        TextHelper.addHeader(stb, key, Integer.toString(value));
    }

    public static byte[] convertToByteArray(String hexData) {
        byte[] result = null;
        try {
            result = Hex.decodeHex((char[])hexData.toCharArray());
        }
        catch (DecoderException de) {
            logger.error(de.getMessage());
        }
        return result;
    }

    public static String[] splitUp(String listedValues) {
        return listedValues.split(",");
    }

    public static Long convertToLong(String decNum) {
        Long result = null;
        try {
            result = Long.parseLong(decNum, 10);
        }
        catch (NumberFormatException nfe) {
            logger.error(nfe.getMessage());
        }
        return result;
    }

    public static Integer convertToInt(String decNum) {
        Integer result = null;
        try {
            result = Integer.parseInt(decNum, 10);
        }
        catch (NumberFormatException nfe) {
            logger.error(nfe.getMessage());
        }
        return result;
    }

    public static Integer convertToIntFromHex(String hexNum) {
        Integer result = null;
        try {
            result = Integer.parseInt(hexNum, 16);
        }
        catch (NumberFormatException nfe) {
            logger.error(nfe.getMessage());
        }
        return result;
    }

    public static Short convertToShort(String decNum) {
        Short result = null;
        try {
            result = Short.parseShort(decNum, 10);
        }
        catch (NumberFormatException nfe) {
            logger.error(nfe.getMessage());
        }
        return result;
    }

    public static Byte convertToByte(String decNum) {
        Byte result = null;
        try {
            result = Byte.parseByte(decNum, 10);
        }
        catch (NumberFormatException nfe) {
            logger.error(nfe.getMessage());
        }
        return result;
    }
}

