/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp.tasks;

import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.SpecialWriteSituation;
import at.mrdevelopment.toolkit.tcp.TCPCommunicationChannel;
import at.mrdevelopment.toolkit.tcp.scheduling.TCPTask;
import at.mrdevelopment.toolkit.tcp.scheduling.TCPTaskLevel;

public class WriteTask
implements TCPTask {
    private static ESLLogger logger = ESLLogger.getLogger(WriteTask.class);
    protected final TCPCommunicationChannel tcpChannel;
    private final byte[] dataArray;
    private final int dataLengthInBytes;
    private final long taskCreationTime;

    public WriteTask(TCPCommunicationChannel tcpChannel) {
        this.tcpChannel = tcpChannel;
        this.dataArray = null;
        this.dataLengthInBytes = -1;
        this.taskCreationTime = System.currentTimeMillis();
    }

    public WriteTask(TCPCommunicationChannel tcpChannel, byte[] dataArray, int dataLengthInBytes) {
        this(tcpChannel, dataArray, dataLengthInBytes, System.currentTimeMillis());
    }

    public WriteTask(TCPCommunicationChannel tcpChannel, byte[] dataArray, int dataLengthInBytes, long taskCreationTime) {
        this.tcpChannel = tcpChannel;
        if (logger.isDebugEnabled()) {
            logger.debug("WriteTask: array.length = %d, dataLength = %d.", dataArray.length, dataLengthInBytes);
        }
        this.dataArray = dataArray;
        this.dataLengthInBytes = dataLengthInBytes;
        this.taskCreationTime = taskCreationTime;
    }

    @Override
    public void run() {
        try {
            if (this.dataArray != null) {
                this.tcpChannel.write(this.dataArray, this.dataLengthInBytes, SpecialWriteSituation.NONE);
            } else {
                this.tcpChannel.write();
            }
        }
        catch (Exception e) {
            logger.logException(e);
        }
    }

    @Override
    public long getTaskTime() {
        return this.taskCreationTime;
    }

    @Override
    public TCPCommunicationChannel getChannel() {
        return this.tcpChannel;
    }

    @Override
    public TCPTaskLevel getTaskLevel() {
        return TCPTaskLevel.NORMAL;
    }
}

