/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp.tasks;

import at.mrdevelopment.toolkit.tcp.FlushResult;
import at.mrdevelopment.toolkit.tcp.TLSCommunicationChannel;

public class FlushTask
implements Runnable {
    protected final TLSCommunicationChannel commChannel;
    protected final long delayInSeconds;

    public FlushTask(TLSCommunicationChannel commChannel) {
        this.commChannel = commChannel;
        this.delayInSeconds = commChannel.flushTaskInitialDelayInSeconds();
    }

    protected FlushTask(TLSCommunicationChannel commChannel, long newDelayInSeconds) {
        this.commChannel = commChannel;
        this.delayInSeconds = newDelayInSeconds;
    }

    @Override
    public void run() {
        FlushResult result = this.commChannel.flush();
        if (result == FlushResult.FULL_FLUSH) {
            this.commChannel.closeTCPOnly();
        } else if (result == FlushResult.PARTIAL_FLUSH) {
            if (this.delayInSeconds < this.commChannel.flushTaskDelayLimitInSeconds()) {
                this.commChannel.submitFlushTask(new FlushTask(this.commChannel, this.delayInSeconds + this.commChannel.partialFlushDelayAdditionInSeconds()));
            } else {
                this.commChannel.closeTLSIgnoreTcp(false);
                this.commChannel.closeTCPOnly();
            }
        } else if (result == FlushResult.NOTHING_FLUSHED) {
            if (this.delayInSeconds < this.commChannel.flushTaskDelayLimitInSeconds()) {
                this.commChannel.submitFlushTask(new FlushTask(this.commChannel, this.delayInSeconds + this.commChannel.nothingFlushedDelayAdditionInSeconds()));
            } else {
                this.commChannel.closeTLSIgnoreTcp(false);
                this.commChannel.closeTCPOnly();
            }
        } else {
            this.commChannel.closeTLSIgnoreTcp(false);
            this.commChannel.closeTCPOnly();
        }
    }

    public long getDelayInSeconds() {
        return this.delayInSeconds;
    }
}

