/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp.scheduling;

import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.scheduling.TCPTask;
import at.mrdevelopment.toolkit.tcp.scheduling.TCPTaskScheduler;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TCPThreadPoolExecutor
extends ThreadPoolExecutor {
    private static ESLLogger logger = ESLLogger.getLogger(TCPThreadPoolExecutor.class);
    private TCPTaskScheduler taskScheduler;

    public TCPThreadPoolExecutor(int threadPoolSize, long keepAliveTime, TimeUnit timeUnit, BlockingQueue<Runnable> queue, TCPTaskScheduler taskScheduler) {
        super(threadPoolSize, threadPoolSize, keepAliveTime, TimeUnit.SECONDS, queue);
        this.taskScheduler = taskScheduler;
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        super.afterExecute(r, t);
        if (r instanceof TCPTask) {
            this.taskScheduler.completed((TCPTask)r);
        } else {
            logger.error("Tried to execute Runnable that was either null or wasn't a TCPTask.");
        }
    }

    public static TCPThreadPoolExecutor createTCPThreadPoolExecutor(int threadPoolSize, long keepAliveTime, TimeUnit timeUnit, TCPTaskScheduler taskScheduler) {
        LinkedBlockingQueue<Runnable> queue = new LinkedBlockingQueue<Runnable>(threadPoolSize * 2);
        return new TCPThreadPoolExecutor(threadPoolSize, keepAliveTime, timeUnit, queue, taskScheduler);
    }
}

