/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp.scheduling;

import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.TCPCommunicationChannel;
import at.mrdevelopment.toolkit.tcp.scheduling.TCPTask;
import at.mrdevelopment.toolkit.tcp.scheduling.TCPTaskScheduler;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class SimplisticTCPTaskScheduler
implements TCPTaskScheduler {
    private static ESLLogger logger = ESLLogger.getLogger(SimplisticTCPTaskScheduler.class);
    private ExecutorService executorService;
    private final String name;

    public SimplisticTCPTaskScheduler(int maxThreadPoolSize, String name) {
        this.name = name;
        this.executorService = Executors.newFixedThreadPool(maxThreadPoolSize);
    }

    private void executorShutdown(String name) {
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(3L, TimeUnit.SECONDS)) {
                logger.error("%s did not finish execution.", name);
            }
        }
        catch (InterruptedException ie) {
            logger.logException(ie);
        }
    }

    @Override
    public void shutdown() {
        this.executorShutdown(this.name);
    }

    @Override
    public void register(TCPCommunicationChannel commChannel) {
    }

    @Override
    public void deregister(TCPCommunicationChannel commChannel) {
    }

    @Override
    public void addTask(TCPTask newTask) {
        try {
            this.executorService.execute(newTask);
        }
        catch (Exception e) {
            logger.logException(e);
        }
    }

    @Override
    public void completed(TCPTask completedTask) {
    }
}

