/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp.scheduling;

import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.TCPCommunicationChannel;
import at.mrdevelopment.toolkit.tcp.scheduling.ChannelTaskInfo;
import at.mrdevelopment.toolkit.tcp.scheduling.QueueOldestTaskComparator;
import at.mrdevelopment.toolkit.tcp.scheduling.StubId;
import at.mrdevelopment.toolkit.tcp.scheduling.TCPTask;
import at.mrdevelopment.toolkit.tcp.scheduling.TCPTaskScheduler;
import at.mrdevelopment.toolkit.tcp.scheduling.TCPThreadPoolExecutor;
import java.util.HashMap;
import java.util.PriorityQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class DefaultTCPTaskScheduler
implements TCPTaskScheduler {
    private static ESLLogger logger = ESLLogger.getLogger(DefaultTCPTaskScheduler.class);
    private static QueueOldestTaskComparator CHANNELS_BY_AGE_COMPARATOR = new QueueOldestTaskComparator();
    private final ExecutorService executorService;
    private final HashMap<Integer, ChannelTaskInfo> channelIdToTaskInfoMapping;
    private final PriorityQueue<ChannelTaskInfo> channelsByAge;
    private final int maxThreadPoolSize;
    private final Lock lock;
    private final String name;
    private int activeWorkerCount;

    public DefaultTCPTaskScheduler(int maxThreadPoolSize, String name) {
        this.name = name;
        this.lock = new ReentrantLock();
        this.maxThreadPoolSize = maxThreadPoolSize;
        this.activeWorkerCount = 0;
        this.channelIdToTaskInfoMapping = new HashMap(32);
        this.channelsByAge = new PriorityQueue<ChannelTaskInfo>(16, CHANNELS_BY_AGE_COMPARATOR);
        this.executorService = TCPThreadPoolExecutor.createTCPThreadPoolExecutor(maxThreadPoolSize, 60L, TimeUnit.SECONDS, this);
    }

    private void assignTasks() {
        ChannelTaskInfo candidate;
        for (int idx = this.activeWorkerCount; idx <= this.maxThreadPoolSize && !this.channelsByAge.isEmpty() && (candidate = this.channelsByAge.peek()).hasQueuedTasks(); ++idx) {
            candidate.execute();
            ++this.activeWorkerCount;
            this.channelsByAge.poll();
        }
    }

    private void executorShutdown(String name) {
        this.executorService.shutdown();
        try {
            if (!this.executorService.awaitTermination(3L, TimeUnit.SECONDS)) {
                logger.error("%s did not finish execution.", name);
            }
        }
        catch (InterruptedException ie) {
            logger.logException(ie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addTask(TCPTask newTask) {
        TCPCommunicationChannel channel = newTask.getChannel();
        StubId id = (StubId)channel.getIdentifier();
        if (logger.isDebugEnabled()) {
            logger.debug("[%s] Adding a task for %d!", this.name, channel.getApId());
        }
        try {
            this.lock.lock();
            ChannelTaskInfo taskInfo = this.channelIdToTaskInfoMapping.get(id.getId());
            if (taskInfo == null) {
                taskInfo = new ChannelTaskInfo(this.executorService);
                this.channelIdToTaskInfoMapping.put(id.getId(), taskInfo);
                taskInfo.queueTask(newTask);
                this.channelsByAge.add(taskInfo);
            } else if (taskInfo.anyTaskInProgress()) {
                taskInfo.queueTask(newTask);
            } else if (!taskInfo.hasQueuedTasks()) {
                taskInfo.queueTask(newTask);
                this.channelsByAge.add(taskInfo);
            }
            this.assignTasks();
            this.log();
        }
        catch (Exception e) {
            logger.logException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void completed(TCPTask completedTask) {
        StubId id = (StubId)completedTask.getChannel().getIdentifier();
        if (logger.isDebugEnabled()) {
            logger.debug("[%s] Completing a task for %d!", this.name, completedTask.getChannel().getApId());
        }
        try {
            this.lock.lock();
            ChannelTaskInfo taskInfo = this.channelIdToTaskInfoMapping.get(id.getId());
            if (taskInfo != null) {
                taskInfo.finished(completedTask);
                if (taskInfo.hasQueuedTasks()) {
                    this.channelsByAge.add(taskInfo);
                }
            } else {
                logger.info("[%s] Channel for completed task, missing! Not really an error it is perfectly possible that it got removed/dc-ed or something.", this.name);
            }
            --this.activeWorkerCount;
            this.assignTasks();
            this.log();
        }
        catch (Exception e) {
            logger.logException(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    private void log() {
        if (logger.isDebugEnabled()) {
            logger.debug("[%s] ChannelIdToInfoMappingSize = %d, activeWorkerCount = %d, channelByAge = %d, maxThreadPoolSize = %d.", this.name, this.channelIdToTaskInfoMapping.size(), this.activeWorkerCount, this.channelsByAge.size(), this.maxThreadPoolSize);
            logger.debug("[%s] %s", this.name, this.channelIdToTaskInfoMapping.toString());
        }
    }

    @Override
    public void shutdown() {
        this.executorShutdown(this.name);
    }

    @Override
    public void register(TCPCommunicationChannel commChannel) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deregister(TCPCommunicationChannel commChannel) {
        try {
            this.lock.lock();
            ChannelTaskInfo taskInfo = this.channelIdToTaskInfoMapping.remove(commChannel.getIdentifier().getId());
            if (taskInfo != null) {
                this.channelsByAge.remove(taskInfo);
            }
        }
        finally {
            this.lock.unlock();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("[%s] Removed channel = %d, apId = %d!", this.name, commChannel.getIdentifier().getId(), commChannel.getApId());
        }
    }
}

