/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp.scheduling;

import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.scheduling.TCPTask;
import at.mrdevelopment.toolkit.tcp.scheduling.TCPTaskLevel;
import java.util.LinkedList;
import java.util.concurrent.ExecutorService;

public class ChannelTaskInfo {
    private static ESLLogger logger = ESLLogger.getLogger(ChannelTaskInfo.class);
    private final LinkedList<TCPTask> internalTasks;
    private final LinkedList<TCPTask> tasks;
    private final ExecutorService service;
    private TCPTask taskInProgress;

    public ChannelTaskInfo(ExecutorService executorService) {
        this.service = executorService;
        this.tasks = new LinkedList();
        this.internalTasks = new LinkedList();
        this.taskInProgress = null;
    }

    boolean anyTaskInProgress() {
        return this.taskInProgress != null;
    }

    boolean hasQueuedTasks() {
        return !this.tasks.isEmpty() || !this.internalTasks.isEmpty();
    }

    public long getOldestTaskTime() {
        return this.tasks.isEmpty() ? (this.internalTasks.isEmpty() ? Long.MAX_VALUE : this.internalTasks.getFirst().getTaskTime()) : this.tasks.getFirst().getTaskTime();
    }

    void queueTask(TCPTask newTask) {
        if (newTask.getTaskLevel() == TCPTaskLevel.INTERNAL) {
            this.internalTasks.add(newTask);
        } else {
            this.tasks.add(newTask);
        }
    }

    void execute() {
        if (this.internalTasks.isEmpty()) {
            if (!this.tasks.isEmpty()) {
                this.taskInProgress = this.tasks.removeFirst();
                this.service.execute(this.taskInProgress);
            }
        } else {
            this.taskInProgress = this.internalTasks.removeFirst();
            this.service.execute(this.taskInProgress);
        }
    }

    void finished(TCPTask oldTask) {
        if (this.taskInProgress == oldTask) {
            this.taskInProgress = null;
        } else {
            logger.error("The task in progress is not the expected task. Something went very wrong!");
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ChannelTaskInfo [tasks=");
        builder.append(this.tasks.size());
        builder.append(", taskInProgress=");
        builder.append(this.taskInProgress != null);
        builder.append("]");
        return builder.toString();
    }
}

