/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp.extern;

import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.extern.ChannelSecurityMode;
import javax.net.ssl.KeyManager;
import javax.net.ssl.TrustManager;

public class TCPCoreConfig {
    private static ESLLogger logger = ESLLogger.getLogger(TCPCoreConfig.class);
    private static final int BUFFER_CHUNK_SIZE = 65536;
    private long connectionTimeout;
    private long selectionTimeout;
    private int writeThreadPoolSize;
    private int readThreadPoolSize;
    private int inputBufferSize;
    private int outputBufferSize;
    private ChannelSecurityMode securityMode;
    private long flushTaskInitialDelayInSeconds;
    private long flushTaskDelayLimitInSeconds;
    private KeyManager[] keyManagers;
    private TrustManager[] trustManagers;
    private boolean clientVerificationRequired;

    public static TCPCoreConfig createServerDefault() {
        Builder builder = new Builder();
        builder.connectionTimeout(15000L);
        builder.inputBufferSize(262144);
        builder.outputBufferSize(262144);
        builder.disableTLS();
        return builder.build();
    }

    public static TCPCoreConfig createTLSServerDefault(KeyManager[] keyManagers, TrustManager[] trustManagers) {
        Builder builder = new Builder();
        builder.connectionTimeout(15000L);
        builder.inputBufferSize(262144);
        builder.outputBufferSize(262144);
        builder.flushTaskDelayLimitInSeconds(5L);
        builder.flushTaskInitialDelayInSeconds(1L);
        builder.setTLSParameters(keyManagers, trustManagers);
        return builder.build();
    }

    public static TCPCoreConfig createTLSServerRequireClientVerification(KeyManager[] keyManagers, TrustManager[] trustManagers) {
        Builder builder = new Builder();
        builder.connectionTimeout(15000L);
        builder.inputBufferSize(262144);
        builder.outputBufferSize(262144);
        builder.flushTaskDelayLimitInSeconds(5L);
        builder.flushTaskInitialDelayInSeconds(1L);
        builder.setTLSParameters(keyManagers, trustManagers);
        builder.clientVerificationRequired();
        return builder.build();
    }

    public static TCPCoreConfig createTLSServerSingleCore(KeyManager[] keyManagers, TrustManager[] trustManagers) {
        Builder builder = new Builder();
        builder.connectionTimeout(15000L);
        builder.readThreadPoolSize(1);
        builder.writeThreadPoolSize(1);
        builder.inputBufferSize(262144);
        builder.outputBufferSize(262144);
        builder.flushTaskDelayLimitInSeconds(5L);
        builder.flushTaskInitialDelayInSeconds(1L);
        builder.setTLSParameters(keyManagers, trustManagers);
        return builder.build();
    }

    public static TCPCoreConfig createAccessPointDefault() {
        Builder builder = new Builder();
        builder.connectionTimeout(15000L);
        builder.readThreadPoolSize(1);
        builder.writeThreadPoolSize(1);
        builder.disableTLS();
        return builder.build();
    }

    private TCPCoreConfig(Builder builder) {
        this.connectionTimeout = builder.connectionTimeout;
        this.selectionTimeout = builder.selectionTimeout;
        this.writeThreadPoolSize = builder.writeThreadPoolSize;
        this.readThreadPoolSize = builder.readThreadPoolSize;
        this.inputBufferSize = builder.inputBufferSize;
        this.outputBufferSize = builder.outputBufferSize;
        this.securityMode = builder.securityMode;
        this.flushTaskInitialDelayInSeconds = builder.flushTaskInitialDelayInSeconds;
        this.flushTaskDelayLimitInSeconds = builder.flushTaskDelayLimitInSeconds;
        this.keyManagers = builder.keyManagers;
        this.trustManagers = builder.trustManagers;
        this.clientVerificationRequired = builder.clientVerificationRequired;
        if (this.securityMode != ChannelSecurityMode.DISABLED) {
            if (this.keyManagers == null) {
                logger.warn("Default Java KeyManagers collection will be used for TLS!");
            }
            if (this.trustManagers == null) {
                logger.warn("Default Java TrustManagers collection will be used for TLS!");
            }
        }
    }

    public boolean autoConfigureWriteThreadPoolSize() {
        return this.writeThreadPoolSize < 1;
    }

    public boolean autoConfigureReadThreadPoolSize() {
        return this.readThreadPoolSize < 1;
    }

    public long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public long getSelectionTimeout() {
        return this.selectionTimeout;
    }

    public int getWriteThreadPoolSize() {
        return this.writeThreadPoolSize;
    }

    public int getReadThreadPoolSize() {
        return this.readThreadPoolSize;
    }

    public int getInputBufferSize() {
        return this.inputBufferSize;
    }

    public int getOutputBufferSize() {
        return this.outputBufferSize;
    }

    public boolean isTLSForced() {
        return this.securityMode == ChannelSecurityMode.FORCE_TLS;
    }

    public boolean isTLSDisabled() {
        return this.securityMode == ChannelSecurityMode.DISABLED;
    }

    public long getFlushTaskInitialDelayInSeconds() {
        return this.flushTaskInitialDelayInSeconds;
    }

    public long getFlushTaskDelayLimitInSeconds() {
        return this.flushTaskDelayLimitInSeconds;
    }

    public KeyManager[] getKeyManagers() {
        return this.keyManagers;
    }

    public TrustManager[] getTrustManagers() {
        return this.trustManagers;
    }

    public boolean isClientVerificationRequired() {
        return this.clientVerificationRequired;
    }

    public static class Builder {
        private long connectionTimeout = 10000L;
        private long selectionTimeout = 50L;
        private int writeThreadPoolSize = -1;
        private int readThreadPoolSize = -1;
        private int inputBufferSize = 262144;
        private int outputBufferSize = 262144;
        private ChannelSecurityMode securityMode = ChannelSecurityMode.NEUTRAL;
        private long flushTaskInitialDelayInSeconds;
        private long flushTaskDelayLimitInSeconds;
        private KeyManager[] keyManagers;
        private TrustManager[] trustManagers;
        private boolean clientVerificationRequired = false;

        public Builder initFrom(TCPCoreConfig otherConfig) {
            this.connectionTimeout = otherConfig.connectionTimeout;
            this.selectionTimeout = otherConfig.selectionTimeout;
            this.writeThreadPoolSize = otherConfig.writeThreadPoolSize;
            this.readThreadPoolSize = otherConfig.readThreadPoolSize;
            this.inputBufferSize = otherConfig.inputBufferSize;
            this.outputBufferSize = otherConfig.outputBufferSize;
            this.securityMode = otherConfig.securityMode;
            this.flushTaskInitialDelayInSeconds = otherConfig.flushTaskInitialDelayInSeconds;
            this.flushTaskDelayLimitInSeconds = otherConfig.flushTaskDelayLimitInSeconds;
            this.keyManagers = otherConfig.keyManagers;
            this.trustManagers = otherConfig.trustManagers;
            this.clientVerificationRequired = otherConfig.clientVerificationRequired;
            return this;
        }

        public Builder setTLSParameters(KeyManager[] keyManagers, TrustManager[] trustManagers) {
            this.keyManagers = keyManagers;
            this.trustManagers = trustManagers;
            return this;
        }

        public Builder connectionTimeout(long connectionTimeout) {
            this.connectionTimeout = connectionTimeout;
            return this;
        }

        public Builder selectionTimeout(long selectionTimeout) {
            this.selectionTimeout = selectionTimeout;
            return this;
        }

        public Builder writeThreadPoolSize(int writeThreadPoolSize) {
            this.writeThreadPoolSize = writeThreadPoolSize;
            return this;
        }

        public Builder readThreadPoolSize(int readThreadPoolSize) {
            this.readThreadPoolSize = readThreadPoolSize;
            return this;
        }

        public Builder inputBufferSize(int inputBufferSize) {
            this.inputBufferSize = inputBufferSize;
            return this;
        }

        public Builder outputBufferSize(int outputBufferSize) {
            this.outputBufferSize = outputBufferSize;
            return this;
        }

        public Builder flushTaskInitialDelayInSeconds(long flushTaskInitialDelayInSeconds) {
            this.flushTaskInitialDelayInSeconds = flushTaskInitialDelayInSeconds;
            return this;
        }

        public Builder flushTaskDelayLimitInSeconds(long flushTaskDelayLimitInSeconds) {
            this.flushTaskDelayLimitInSeconds = flushTaskDelayLimitInSeconds;
            return this;
        }

        public Builder forceTLSUse() {
            this.securityMode = ChannelSecurityMode.FORCE_TLS;
            return this;
        }

        public Builder disableTLS() {
            this.securityMode = ChannelSecurityMode.DISABLED;
            return this;
        }

        public Builder clientVerificationRequired() {
            this.clientVerificationRequired = true;
            return this;
        }

        public TCPCoreConfig build() {
            return new TCPCoreConfig(this);
        }
    }
}

