/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp.dummy;

import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.TCPCommunicationChannel;
import at.mrdevelopment.toolkit.tcp.TCPEventStrategy;
import at.mrdevelopment.toolkit.tcp.TCPSource;
import at.mrdevelopment.toolkit.tcp.dummy.DummyParameters;
import at.mrdevelopment.toolkit.tcp.dummy.DummySendPeriodically;
import java.nio.ByteBuffer;
import java.nio.channels.NonReadableChannelException;

public class DummyTcpEventStrategy
implements TCPEventStrategy {
    private static ESLLogger logger = ESLLogger.getLogger(DummyTcpEventStrategy.class);
    private ByteBuffer inputBuffer;
    private int unprocessedBytes = 0;
    private final int BYTES_TO_PROCESS_IN_BULK = 2048;
    private final byte[] data = new byte[2048];
    private final DummySendPeriodically dummySendPeriodically;

    public DummyTcpEventStrategy(DummyParameters params) {
        this.inputBuffer = ByteBuffer.allocate(65536);
        this.dummySendPeriodically = new DummySendPeriodically(params);
    }

    @Override
    public int getApId() {
        return 0;
    }

    private void handlePacketContents(TCPSource source, ByteBuffer inboundBuffer, int bytesInPacket) {
        inboundBuffer.get(this.data, 0, bytesInPacket);
    }

    @Override
    public boolean readAndDecode(TCPSource source) {
        ByteBuffer inboundDataBuffer = source.getChannel().getInboundDataBuffer();
        boolean noError = true;
        try {
            inboundDataBuffer.flip();
            int bytesRead = inboundDataBuffer.remaining();
            this.inputBuffer.put(inboundDataBuffer);
            inboundDataBuffer.compact();
            if (logger.isDebugEnabled()) {
                logger.debug("Read %d bytes (common).", bytesRead);
            }
            if (bytesRead >= 0) {
                this.unprocessedBytes += bytesRead;
                this.inputBuffer.flip();
                while (this.unprocessedBytes >= 2048) {
                    if (this.unprocessedBytes < 2048) continue;
                    this.unprocessedBytes -= 2048;
                    logger.debug("handlingPacket ====");
                    this.handlePacketContents(source, this.inputBuffer, 2048);
                }
                this.inputBuffer.compact();
            }
        }
        catch (NonReadableChannelException nrce) {
            logger.error("Channel was not opened for reading. Programming error.");
            noError = false;
        }
        catch (Exception e) {
            logger.error("Got exception when reading from channel. Details: %s", e.getMessage());
            logger.logException(e);
            noError = false;
        }
        return noError;
    }

    @Override
    public void doAfterSuccesfullyConnected(TCPSource source) {
        logger.error("In doAfterSuccesfullyConnected!");
    }

    @Override
    public void doAfterConnectAttemptFailed(TCPSource source) {
        logger.error("In doAfterConnectAttemptFailed!");
    }

    @Override
    public void doAfterWasAccepted(TCPSource source) {
        this.dummySendPeriodically.setTcpChannel(source.getChannel());
        Thread newThread = new Thread(this.dummySendPeriodically);
        newThread.start();
        logger.error("In doAfterWasAccepted!");
    }

    @Override
    public void detectedDisconnect(TCPCommunicationChannel comChannel) {
        this.dummySendPeriodically.close();
        logger.error("In detectedDisconnect!");
    }
}

