/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp.dummy;

import at.mrdevelopment.toolkit.tcp.TCPCommunicationChannel;
import at.mrdevelopment.toolkit.tcp.dummy.DummyParameters;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicBoolean;

public class DummySendPeriodically
implements Runnable {
    private AtomicBoolean execute = new AtomicBoolean(true);
    private TCPCommunicationChannel tcpChannel;
    private final DummyParameters params;

    public DummySendPeriodically(DummyParameters params) {
        this.params = params;
    }

    public void setTcpChannel(TCPCommunicationChannel newTcpChannel) {
        this.tcpChannel = newTcpChannel;
    }

    @Override
    public void run() {
        byte[] dataArray = new byte[20];
        Arrays.fill(dataArray, (byte)127);
        long startTime = System.currentTimeMillis();
        while (this.execute.get()) {
            try {
                Thread.sleep(this.params.getSendIntervalMillis());
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.tcpChannel.getSource().submit(dataArray, dataArray.length);
            if (this.params.getCloseAfterSecondsInMillis() < 0L || System.currentTimeMillis() - startTime < this.params.getCloseAfterSecondsInMillis()) continue;
            this.tcpChannel.getSource().submitClose();
            this.execute.set(false);
        }
    }

    public void close() {
        this.execute.set(false);
    }
}

