/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp;

import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.CloseWriteQueueElement;
import at.mrdevelopment.toolkit.tcp.DefaultTCPCommunicationChannel;
import at.mrdevelopment.toolkit.tcp.FlushResult;
import at.mrdevelopment.toolkit.tcp.IOLogicEndpoint;
import at.mrdevelopment.toolkit.tcp.ProcessForWriteContext;
import at.mrdevelopment.toolkit.tcp.SpecialWriteSituation;
import at.mrdevelopment.toolkit.tcp.TCPDefaultWriteQueueElement;
import at.mrdevelopment.toolkit.tcp.TCPTLSMode;
import at.mrdevelopment.toolkit.tcp.TCPWriteQueueElement;
import at.mrdevelopment.toolkit.tcp.TLSCloseState;
import at.mrdevelopment.toolkit.tcp.extern.TCPCoreConfig;
import at.mrdevelopment.toolkit.tcp.scheduling.TCPTaskLevel;
import at.mrdevelopment.toolkit.tcp.tasks.FlushTask;
import at.mrdevelopment.toolkit.tcp.tasks.InternalCloseTask;
import at.mrdevelopment.toolkit.tcp.tasks.TriggerWrapTask;
import at.mrdevelopment.toolkit.tcp.tasks.WrapFlushTask;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SocketChannel;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

public class TLSCommunicationChannel
extends DefaultTCPCommunicationChannel {
    private static ESLLogger logger = ESLLogger.getLogger(TLSCommunicationChannel.class);
    private static final int QUEUE_LIMIT = 10;
    private static final long PARTIAL_FLUSH_DELAY_ADDITION = 1L;
    private static final long NOTHING_FLUSHED_DELAY_ADDITION = 2L;
    private SSLEngine sslEngine;
    private ByteBuffer inboundRawDataBuffer;
    private ByteBuffer inboundDataBuffer;
    private ByteBuffer outboundRawDataBuffer;
    private final TLSCloseState closeState;
    private boolean gotIoError;
    private boolean canCloseTcp;

    public TLSCommunicationChannel(TCPCoreConfig config, TCPTLSMode tlsMode, SSLEngine newSslEngine) {
        super(config, IOLogicEndpoint.BUFFER, false);
        this.sslEngine = newSslEngine;
        this.sslEngine.setUseClientMode(tlsMode == TCPTLSMode.AS_CLIENT);
        if (!this.sslEngine.getUseClientMode()) {
            this.sslEngine.setNeedClientAuth(config.isClientVerificationRequired());
        }
        this.inboundDataBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getApplicationBufferSize());
        logger.info("InboundDataBufferSize = %d!", this.inboundDataBuffer.capacity());
        this.inboundDataBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.inboundRawDataBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getPacketBufferSize());
        logger.info("InboundRawDataBufferSize = %d!", this.inboundRawDataBuffer.capacity());
        this.outboundDataBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getApplicationBufferSize());
        this.outboundDataBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.outboundRawDataBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getPacketBufferSize());
        this.closeState = new TLSCloseState(this);
        this.gotIoError = false;
        this.canCloseTcp = false;
    }

    public TLSCommunicationChannel(TCPCoreConfig config, TCPTLSMode tlsMode, SSLEngine newSslEngine, SocketChannel providedChannel) {
        super(config, providedChannel, IOLogicEndpoint.BUFFER, false);
        this.sslEngine = newSslEngine;
        this.sslEngine.setUseClientMode(tlsMode == TCPTLSMode.AS_CLIENT);
        if (!this.sslEngine.getUseClientMode()) {
            this.sslEngine.setNeedClientAuth(config.isClientVerificationRequired());
        }
        this.inboundDataBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getApplicationBufferSize());
        logger.info("InboundDataBufferSize = %d!", this.inboundDataBuffer.capacity());
        this.inboundDataBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.inboundRawDataBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getPacketBufferSize());
        logger.info("InboundRawDataBufferSize = %d!", this.inboundRawDataBuffer.capacity());
        this.outboundDataBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getApplicationBufferSize());
        this.outboundDataBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.outboundRawDataBuffer = ByteBuffer.allocate(this.sslEngine.getSession().getPacketBufferSize());
        this.closeState = new TLSCloseState(this);
        this.gotIoError = false;
        this.canCloseTcp = false;
    }

    private void executeDelegatedTasks() {
        Runnable task;
        while ((task = this.sslEngine.getDelegatedTask()) != null) {
            task.run();
        }
    }

    private void simpleLogEntry(String message, String connIdStr, SSLEngineResult.HandshakeStatus hs) {
        if (logger.isDebugEnabled()) {
            logger.debug(message, connIdStr, hs.name());
        }
    }

    private boolean processHandshakeForRead(SSLEngineResult result, int bytesInRawDataBuffer) {
        boolean continueProcessing = false;
        if (logger.isDebugEnabled()) {
            logger.debug("%s ProcessHandshake: OP_TYPE = READ, OP_Status = %s, HS_Status = %s!", super.getConnectionIdStr(), result.getStatus().name(), result.getHandshakeStatus().name());
        }
        SSLEngineResult.HandshakeStatus hs = result.getHandshakeStatus();
        switch (hs) {
            case NEED_TASK: {
                this.executeDelegatedTasks();
                continueProcessing = true;
                break;
            }
            case NEED_UNWRAP: {
                if (result.getStatus() == SSLEngineResult.Status.OK) {
                    if (bytesInRawDataBuffer <= result.bytesConsumed()) break;
                    continueProcessing = true;
                    break;
                }
                if (result.getStatus() == SSLEngineResult.Status.CLOSED) {
                    this.simpleLogEntry("%s %s got CLOSED on READ! No action taken!", super.getConnectionIdStr(), hs);
                    break;
                }
                if (result.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                    this.simpleLogEntry("%s %s got buffer underflow! No need to do anything!", super.getConnectionIdStr(), hs);
                    break;
                }
                this.simpleLogEntry("%s %s got buffer overflow, should never happen!", super.getConnectionIdStr(), hs);
                break;
            }
            case NEED_WRAP: {
                this.source.submit(new TriggerWrapTask(this));
                break;
            }
            case FINISHED: {
                continueProcessing = true;
                this.source.submit(new TriggerWrapTask(this));
                break;
            }
            case NOT_HANDSHAKING: {
                if (result.getStatus() == SSLEngineResult.Status.OK) {
                    if (bytesInRawDataBuffer <= result.bytesConsumed()) break;
                    continueProcessing = true;
                    break;
                }
                if (result.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW && result.getStatus() != SSLEngineResult.Status.BUFFER_OVERFLOW) break;
            }
        }
        return continueProcessing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readOnOk() {
        try {
            this.readLock.lock();
            this.protocolStrategy.readAndDecode(this.source);
        }
        catch (Exception e) {
            logger.logException(e);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read() {
        if (this.closeState.isReadDisabled()) {
            return;
        }
        boolean readSuccesful = false;
        boolean exception = false;
        try {
            this.readLock.lock();
            int bytesRead = -1;
            do {
                int bytesInRawDataBuffer;
                SSLEngineResult result;
                if (this.sslEngine.isInboundDone()) {
                    return;
                }
                bytesRead = this.channel.read(this.inboundRawDataBuffer);
                do {
                    this.inboundRawDataBuffer.flip();
                    bytesInRawDataBuffer = this.inboundRawDataBuffer.limit();
                    result = this.sslEngine.unwrap(this.inboundRawDataBuffer, this.inboundDataBuffer);
                    if (logger.isDebugEnabled() && (result.bytesConsumed() > 0 || result.bytesProduced() > 0)) {
                        logger.debug("%s Unwrap - Consumed = %d, Produced = %d!", this.getConnectionIdStr(), result.bytesConsumed(), result.bytesProduced());
                    }
                    this.inboundRawDataBuffer.compact();
                    readSuccesful = true;
                    switch (result.getStatus()) {
                        case BUFFER_UNDERFLOW: {
                            if (!logger.isDebugEnabled()) break;
                            if (this.inboundRawDataBuffer.capacity() != this.sslEngine.getSession().getPacketBufferSize()) {
                                logger.debug("New requested packet Buffer Size = %d, old Size = %d!", this.sslEngine.getSession().getPacketBufferSize(), this.inboundRawDataBuffer.capacity());
                                break;
                            }
                            logger.debug("Buffer underflow!");
                            break;
                        }
                        case BUFFER_OVERFLOW: {
                            if (!logger.isDebugEnabled()) break;
                            if (this.inboundDataBuffer.capacity() != this.sslEngine.getSession().getApplicationBufferSize()) {
                                logger.debug("New requested app Buffer Size = %d, old Size = %d!", this.sslEngine.getSession().getApplicationBufferSize(), this.inboundDataBuffer.capacity());
                                break;
                            }
                            logger.debug("Buffer overflow!");
                            break;
                        }
                        case CLOSED: {
                            logger.debug("%s Got CLOSED in Read: Initiated by = %s!", super.getConnectionIdStr(), this.closeState.getInitiatorStr());
                            if (this.closeState.initiateByRemote()) {
                                logger.debug("%s SSLEngine isInboundDone: assumed==true, actual==%b!", super.getConnectionIdStr(), this.sslEngine.isInboundDone());
                                break;
                            }
                            if (this.closeState.wasInitiatedByLocal()) {
                                logger.debug("%s Got optional CLOSED!", super.getConnectionIdStr());
                                break;
                            }
                            logger.debug("%s Got CLOSED by remote a second time!, Something is very wrong!", super.getConnectionIdStr());
                            break;
                        }
                        case OK: {
                            this.readOnOk();
                        }
                    }
                } while (this.processHandshakeForRead(result, bytesInRawDataBuffer));
            } while (bytesRead > 0);
            if (bytesRead == -1) {
                if (!this.sslEngine.isInboundDone()) {
                    this.sslEngine.closeInbound();
                    if (logger.isInfoEnabled()) {
                        logger.info("%s Called closeInbound!", super.getConnectionIdStr());
                    }
                } else if (logger.isInfoEnabled()) {
                    logger.info("%s End of stream inbound is done!", super.getConnectionIdStr());
                }
                readSuccesful = false;
            }
        }
        catch (SSLException ssle) {
            logger.error("%s Got SSLException in read! Channel will be closed!", super.getConnectionIdStr());
            logger.logException(ssle);
            this.closeState.initiatedBySSLException();
            this.closeState.disableRead();
            exception = true;
        }
        catch (IOException ioe) {
            logger.info("%s Got IOException in read!", super.getConnectionIdStr());
            logger.logException(ioe);
            this.closeState.initiatedByIOException();
            this.closeState.disableRead();
            exception = true;
        }
        catch (Exception e) {
            logger.error("%s Got other Exception in read!", super.getConnectionIdStr());
            logger.logException(e);
            this.closeState.initiatedByOtherException();
            this.closeState.disableRead();
            exception = true;
        }
        finally {
            this.readLock.unlock();
        }
        if (exception) {
            if (logger.isDebugEnabled()) {
                logger.debug("%s Inbound closed: %b!", super.getConnectionIdStr(), this.sslEngine.isInboundDone());
            }
            this.source.submit(InternalCloseTask.createReadTriggeredCloseTask(this));
        } else if (!readSuccesful) {
            if (logger.isDebugEnabled()) {
                logger.debug("%s Submitting read triggerd close task because read was not successful!", super.getConnectionIdStr());
            }
            this.source.submit(InternalCloseTask.createReadTriggeredCloseTask(this));
        } else {
            this.lastActivityTime = System.currentTimeMillis();
            if (logger.isDebugEnabled() && this.protocolStrategy != null) {
                logger.debug("%s Done read for AP-ID = %d!", super.getConnectionIdStr(), this.protocolStrategy.getApId());
            }
            try {
                this.addInterestOp(1);
            }
            catch (Exception e) {
                logger.logException(e);
            }
        }
    }

    private void immediateTLSClose(boolean doNotWriteToChannel) {
        ProcessForWriteContext writeContext = new ProcessForWriteContext();
        this.sslEngine.closeOutbound();
        do {
            writeContext.repeatWrapIn = false;
            writeContext.enResultIn = this.wrap();
            if (writeContext.enResultIn == null) break;
            writeContext.fResultIn = FlushResult.NOT_AVAILABLE;
            switch (writeContext.enResultIn.getStatus()) {
                case BUFFER_UNDERFLOW: {
                    if (this.outboundRawDataBuffer.position() <= 0) break;
                    writeContext.fResultIn = this.completeFlush(false, doNotWriteToChannel);
                    writeContext.fResultIn = FlushResult.FULL_FLUSH;
                    break;
                }
                case BUFFER_OVERFLOW: {
                    writeContext.fResultIn = this.completeFlush(false, doNotWriteToChannel);
                    if (writeContext.fResultIn == FlushResult.FULL_FLUSH) break;
                    this.outboundRawDataBuffer.clear();
                    writeContext.fResultIn = FlushResult.FULL_FLUSH;
                    break;
                }
                case CLOSED: {
                    if (logger.isDebugEnabled()) {
                        logger.debug("%s Got CLOSED in immediateTLSClose(), initiated by %s! [outbound, inbound] done: [%b, %b]", super.getConnectionIdStr(), this.closeState.getInitiatorStr(), this.sslEngine.isOutboundDone(), this.sslEngine.isInboundDone());
                    }
                    this.completeFlush(false, doNotWriteToChannel);
                    break;
                }
                case OK: {
                    writeContext.fResultIn = this.completeFlush(false, doNotWriteToChannel);
                    if (writeContext.fResultIn != FlushResult.FULL_FLUSH) {
                        this.outboundRawDataBuffer.clear();
                        writeContext.fResultIn = FlushResult.FULL_FLUSH;
                    }
                    writeContext.repeatWrapIn = false;
                }
            }
        } while (this.processHandshakeForWrite(writeContext));
        if (logger.isDebugEnabled()) {
            logger.debug("%s immediateTLSClose(), SSLEngine state; [outbound, inbound] done: [%b, %b]", super.getConnectionIdStr(), this.sslEngine.isOutboundDone(), this.sslEngine.isInboundDone());
        }
    }

    private FlushResult completeFlush(boolean doOps, boolean doNotWriteToChannel) {
        FlushResult retValue = FlushResult.EXCEPTION;
        try {
            int positionBefore = 0;
            if (doNotWriteToChannel) {
                this.outboundRawDataBuffer.clear();
                positionBefore = this.outboundRawDataBuffer.position();
            } else {
                positionBefore = this.outboundRawDataBuffer.position();
                this.outboundRawDataBuffer.flip();
                this.channel.write(this.outboundRawDataBuffer);
                this.outboundRawDataBuffer.compact();
            }
            if (this.outboundRawDataBuffer.position() == 0) {
                this.channelNotReadyToWrite = false;
                retValue = FlushResult.FULL_FLUSH;
                if (doOps) {
                    this.removeInterestOp(4);
                }
            } else if (positionBefore != this.outboundRawDataBuffer.position()) {
                this.channelNotReadyToWrite = true;
                retValue = FlushResult.PARTIAL_FLUSH;
                if (doOps) {
                    this.addInterestOp(4);
                }
            } else {
                this.channelNotReadyToWrite = true;
                retValue = FlushResult.NOTHING_FLUSHED;
                if (doOps) {
                    this.addInterestOp(4);
                }
            }
        }
        catch (NotYetConnectedException nyce) {
            logger.error("%s Tried to write to a channel that has not yet been connected.", super.getConnectionIdStr());
        }
        catch (IOException ioe) {
            this.channelNotReadyToWrite = false;
            if (doOps) {
                this.removeInterestOp(4);
            }
            logger.logException(ioe);
        }
        if (logger.isDebugEnabled() && (retValue.isChannelFull() || retValue == FlushResult.EXCEPTION)) {
            logger.debug("%s Complete flush result: %s!", super.getConnectionIdStr(), retValue.name());
        }
        return retValue;
    }

    private FlushResult completeFlush(boolean doOps) {
        return this.completeFlush(doOps, false);
    }

    private boolean processHandshakeForWrite(ProcessForWriteContext writeContext) {
        boolean repeatWrapResult = writeContext.repeatWrapIn;
        if (logger.isDebugEnabled()) {
            logger.debug("%s " + writeContext.toString(), super.getConnectionIdStr());
        }
        switch (writeContext.enResultIn.getHandshakeStatus()) {
            case NEED_TASK: {
                this.executeDelegatedTasks();
                break;
            }
            case NEED_UNWRAP: {
                writeContext.repeatQueueProcessingOut = false;
                break;
            }
            case NEED_WRAP: {
                switch (writeContext.enResultIn.getStatus()) {
                    case BUFFER_OVERFLOW: {
                        repeatWrapResult = writeContext.fResultIn == FlushResult.FULL_FLUSH ? true : repeatWrapResult;
                        break;
                    }
                    case CLOSED: {
                        break;
                    }
                    case BUFFER_UNDERFLOW: 
                    case OK: {
                        repeatWrapResult = true;
                    }
                }
                break;
            }
            case FINISHED: {
                if (this.outboundDataBuffer.position() > 0) {
                    repeatWrapResult = true;
                }
                if (writeContext.writeQueueCompletelyEmptyOfUserDataIn) break;
                writeContext.repeatQueueProcessingOut = true;
                break;
            }
            case NOT_HANDSHAKING: {
                if (writeContext.enResultIn.getStatus() == SSLEngineResult.Status.OK || writeContext.enResultIn.getStatus() == SSLEngineResult.Status.BUFFER_OVERFLOW) {
                    repeatWrapResult = writeContext.fResultIn == FlushResult.FULL_FLUSH ? true : repeatWrapResult;
                    break;
                }
                if (writeContext.enResultIn.getStatus() == SSLEngineResult.Status.BUFFER_UNDERFLOW) {
                    if (writeContext.writeQueueCompletelyEmptyOfUserDataIn) break;
                    writeContext.repeatQueueProcessingOut = true;
                    break;
                }
                if (!logger.isInfoEnabled()) break;
                logger.info("%s Got %s with HS = %s!", super.getConnectionIdStr(), writeContext.enResultIn.getStatus().name(), writeContext.enResultIn.getHandshakeStatus().name());
            }
        }
        return repeatWrapResult;
    }

    private SSLEngineResult innerWrap() throws SSLException {
        SSLEngineResult result = null;
        if (logger.isInfoEnabled()) {
            logger.info("%s HandshakeStatus before wrap: %s!", super.getConnectionIdStr(), this.sslEngine.getHandshakeStatus().name());
        }
        this.outboundDataBuffer.flip();
        result = this.sslEngine.wrap(this.outboundDataBuffer, this.outboundRawDataBuffer);
        if (logger.isDebugEnabled() && (result.bytesConsumed() > 0 || result.bytesProduced() > 0)) {
            logger.debug("%s Wrap - Consumed = %d, Produced = %d!", super.getConnectionIdStr(), result.bytesConsumed(), result.bytesProduced());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SSLEngineResult wrap() {
        SSLEngineResult result = null;
        try {
            result = this.innerWrap();
        }
        catch (SSLException ssle) {
            logger.logException(ssle);
        }
        finally {
            this.outboundDataBuffer.compact();
        }
        if (result == null) {
            try {
                this.sslEngine.closeOutbound();
                result = this.innerWrap();
            }
            catch (SSLException ssle) {
                logger.logException(ssle);
            }
            finally {
                this.outboundDataBuffer.compact();
            }
        }
        return result;
    }

    private void writeLogic(boolean checkQueue, boolean wrapFlushTask, long delayInSeconds) {
        ProcessForWriteContext writeContext = new ProcessForWriteContext();
        writeContext.repeatQueueProcessingOut = false;
        do {
            writeContext.writeQueueCompletelyEmptyOfUserDataIn = true;
            if (this.sslEngine.isOutboundDone()) {
                if (this.canCloseTcp) {
                    return;
                }
            } else if (checkQueue) {
                while (!this.writeQueue.isEmpty()) {
                    TCPWriteQueueElement element = (TCPWriteQueueElement)this.writeQueue.peek();
                    if (element.isClose()) {
                        element = (TCPWriteQueueElement)this.writeQueue.remove();
                        if (element.getTaskLevel() != TCPTaskLevel.NORMAL) break;
                        this.sslEngine.closeOutbound();
                        break;
                    }
                    if (element.transferTo(this.outboundDataBuffer)) {
                        this.writeQueue.remove();
                        continue;
                    }
                    writeContext.writeQueueCompletelyEmptyOfUserDataIn = false;
                    break;
                }
            }
            writeContext.repeatQueueProcessingOut = false;
            block8: do {
                writeContext.repeatWrapIn = false;
                writeContext.enResultIn = this.wrap();
                if (writeContext.enResultIn == null) {
                    this.canCloseTcp = true;
                    break;
                }
                writeContext.fResultIn = FlushResult.NOT_AVAILABLE;
                switch (writeContext.enResultIn.getStatus()) {
                    case BUFFER_UNDERFLOW: {
                        if (this.gotIoError || this.outboundRawDataBuffer.position() <= 0) continue block8;
                        if (logger.isDebugEnabled()) {
                            logger.debug("%s Doing flush in buffer underflow situation (if buffer not empty).", super.getConnectionIdStr());
                        }
                        writeContext.fResultIn = this.completeFlush(true);
                        if (writeContext.fResultIn == FlushResult.FULL_FLUSH || writeContext.fResultIn.isChannelFull()) continue block8;
                        this.closeState.initiatedByIOException();
                        this.outboundRawDataBuffer.clear();
                        this.gotIoError = true;
                        writeContext.fResultIn = FlushResult.FULL_FLUSH;
                        this.sslEngine.closeOutbound();
                        break;
                    }
                    case BUFFER_OVERFLOW: {
                        TLSCloseState.TimeoutCloseState temp;
                        if (!this.gotIoError) {
                            writeContext.fResultIn = this.completeFlush(true);
                            if (writeContext.fResultIn == FlushResult.EXCEPTION) {
                                this.outboundRawDataBuffer.clear();
                                this.gotIoError = true;
                                writeContext.fResultIn = FlushResult.FULL_FLUSH;
                                this.sslEngine.closeOutbound();
                                this.closeState.initiatedByIOException();
                                break;
                            }
                            if (!writeContext.fResultIn.isChannelFull()) break;
                            temp = this.closeState.doTimeoutCloseLogic();
                            if (temp == TLSCloseState.TimeoutCloseState.TIMEOUT_RECEIVED) {
                                this.source.getCore().submit(new WrapFlushTask(this));
                                break;
                            }
                            if (temp != TLSCloseState.TimeoutCloseState.FLUSH_TASK_TRIGGERED || !wrapFlushTask) continue block8;
                            if (delayInSeconds < this.flushTaskDelayLimitInSeconds()) {
                                long newDelayInSeconds = delayInSeconds;
                                this.source.getCore().submit(new WrapFlushTask(this, newDelayInSeconds += writeContext.fResultIn == FlushResult.PARTIAL_FLUSH ? this.partialFlushDelayAdditionInSeconds() : this.nothingFlushedDelayAdditionInSeconds()));
                                break;
                            }
                            this.outboundRawDataBuffer.clear();
                            writeContext.fResultIn = FlushResult.FULL_FLUSH;
                            break;
                        }
                        this.outboundRawDataBuffer.clear();
                        writeContext.fResultIn = FlushResult.FULL_FLUSH;
                        break;
                    }
                    case CLOSED: {
                        TLSCloseState.TimeoutCloseState temp;
                        if (logger.isDebugEnabled()) {
                            logger.error("%s Got CLOSED at wrap, initiated by %s! [outbound, inbound] done: [%b, %b]", super.getConnectionIdStr(), this.closeState.getInitiatorStr(), this.sslEngine.isOutboundDone(), this.sslEngine.isInboundDone());
                        }
                        if (!this.gotIoError) {
                            writeContext.fResultIn = this.completeFlush(true);
                            if (writeContext.fResultIn == FlushResult.FULL_FLUSH) {
                                this.canCloseTcp = true;
                                break;
                            }
                            if (writeContext.fResultIn.isChannelFull()) {
                                temp = this.closeState.doTimeoutCloseLogic();
                                if (temp == TLSCloseState.TimeoutCloseState.TIMEOUT_RECEIVED) {
                                    this.source.getCore().submit(new FlushTask(this));
                                    break;
                                }
                                if (temp != TLSCloseState.TimeoutCloseState.FLUSH_TASK_TRIGGERED || !wrapFlushTask) continue block8;
                                this.source.getCore().submit(new FlushTask(this));
                                break;
                            }
                            this.closeState.initiatedByIOException();
                            this.gotIoError = true;
                            this.canCloseTcp = true;
                            break;
                        }
                        this.canCloseTcp = true;
                        break;
                    }
                    case OK: {
                        if (writeContext.writeQueueCompletelyEmptyOfUserDataIn) {
                            if (!this.gotIoError) {
                                if (writeContext.enResultIn.bytesProduced() <= 0) break;
                                writeContext.fResultIn = this.completeFlush(true);
                                if (writeContext.fResultIn != FlushResult.EXCEPTION) break;
                                this.outboundRawDataBuffer.clear();
                                this.gotIoError = true;
                                writeContext.fResultIn = FlushResult.FULL_FLUSH;
                                this.sslEngine.closeOutbound();
                                break;
                            }
                            this.outboundRawDataBuffer.clear();
                            writeContext.fResultIn = FlushResult.FULL_FLUSH;
                            break;
                        }
                        writeContext.repeatQueueProcessingOut = true;
                    }
                }
            } while (this.processHandshakeForWrite(writeContext));
            if (!this.canCloseTcp) continue;
            writeContext.repeatQueueProcessingOut = false;
            this.closeTCPOnly();
            if (!logger.isDebugEnabled()) continue;
            logger.debug("%s In writeLogic(...), also closed TCP [outbound, inbound] done: [%b, %b]", super.getConnectionIdStr(), this.sslEngine.isOutboundDone(), this.sslEngine.isInboundDone());
        } while (writeContext.repeatQueueProcessingOut);
    }

    private void specialWriteSituationHandling(SpecialWriteSituation specialSituation) {
        if (specialSituation == SpecialWriteSituation.APPLICATION_TRIGGERED_CLOSE) {
            this.writeQueue.clear();
            this.writeQueue.add(new CloseWriteQueueElement(TCPTaskLevel.NORMAL));
            this.closeState.receivedNotTimeoutTriggeredClose();
        } else if (specialSituation == SpecialWriteSituation.READ_TRIGGERED_CLOSE) {
            this.writeQueue.clear();
            this.writeQueue.add(new CloseWriteQueueElement(TCPTaskLevel.INTERNAL));
            if (!this.sslEngine.isInboundDone()) {
                this.sslEngine.closeOutbound();
            }
            this.closeState.receivedNotTimeoutTriggeredClose();
        }
        if (logger.isDebugEnabled() && specialSituation != SpecialWriteSituation.NONE) {
            logger.debug("%s Received: %s!", new Object[]{super.getConnectionIdStr(), specialSituation});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void write(byte[] dataArray, int dataLengthInBytes, boolean isTriggeredBySelectorWriteEvent, SpecialWriteSituation specialSituation) {
        try {
            this.writeLock.lock();
            if (this.sslEngine.isOutboundDone()) {
                if (logger.isDebugEnabled()) {
                    logger.debug("%s Write call but Outbound is done!", super.getConnectionIdStr());
                }
                return;
            }
            if (logger.isDebugEnabled()) {
                if (this.writeQueue.size() > 1) {
                    logger.debug("%s WriteQueueSize = %d.", super.getConnectionIdStr(), this.writeQueue.size());
                }
                if (this.channelNotReadyToWrite) {
                    logger.debug("%s channelNotReadyToWrite = true, isTriggeredBySelectorWriteEvent = %b", super.getConnectionIdStr(), isTriggeredBySelectorWriteEvent);
                }
            }
            if (specialSituation == SpecialWriteSituation.TIMEOUT_TRIGGERED_CLOSE) {
                if (logger.isDebugEnabled()) {
                    logger.debug("%s Received: %s!", new Object[]{super.getConnectionIdStr(), specialSituation});
                }
                this.writeQueue.clear();
                this.writeQueue.add(new CloseWriteQueueElement(TCPTaskLevel.INTERNAL));
                this.sslEngine.closeOutbound();
                this.closeState.receivedTimeoutClose();
                this.writeLogic(true, false, 0L);
            } else if (!this.closeState.alreadyReceivedNotTimeoutTriggeredClose()) {
                if (this.channelNotReadyToWrite && !isTriggeredBySelectorWriteEvent) {
                    if (specialSituation == SpecialWriteSituation.NONE) {
                        if (this.writeQueue.size() < 10) {
                            this.writeQueue.add(new TCPDefaultWriteQueueElement(dataArray, dataLengthInBytes));
                        }
                    } else {
                        this.specialWriteSituationHandling(specialSituation);
                        if (logger.isDebugEnabled()) {
                            logger.debug("%s Cannot do write logic for some reason!", super.getConnectionIdStr());
                        }
                    }
                } else {
                    if (dataArray != null) {
                        if (this.writeQueue.size() < 10) {
                            this.writeQueue.add(new TCPDefaultWriteQueueElement(dataArray, dataLengthInBytes));
                        }
                    } else {
                        this.specialWriteSituationHandling(specialSituation);
                    }
                    this.writeLogic(true, false, 0L);
                }
            } else if (isTriggeredBySelectorWriteEvent) {
                this.writeLogic(true, false, 0L);
            }
        }
        catch (Exception e) {
            logger.logException(e);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void initiateCloseAndSendNotify(boolean timeoutClose) {
        if (!this.sslEngine.isOutboundDone()) {
            InternalCloseTask ict = timeoutClose ? InternalCloseTask.createTimeoutTriggeredCloseTask(this) : InternalCloseTask.createAppTriggeredCloseTask(this);
            this.source.getCore().submit(ict);
            if (logger.isDebugEnabled()) {
                logger.debug("%s Submiting internal task %s!", super.getConnectionIdStr(), ict);
            }
        } else if (timeoutClose) {
            InternalCloseTask ict = InternalCloseTask.createTimeoutTriggeredCloseTask(this);
            this.source.getCore().submit(ict);
            if (logger.isDebugEnabled()) {
                logger.debug("%s Submiting internal task %s!", super.getConnectionIdStr(), ict);
            }
        }
    }

    public void initiateCloseTLSLogic(boolean timeoutClose) {
        if (this.closeState.initiateByLocal()) {
            this.initiateCloseAndSendNotify(timeoutClose);
        } else if (timeoutClose && this.closeState.triggerTimeout()) {
            this.initiateCloseAndSendNotify(true);
        }
    }

    @Override
    public ByteBuffer getInboundDataBuffer() {
        return this.inboundDataBuffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void triggerSSLEngineWrap() {
        try {
            this.writeLock.lock();
            this.writeLogic(false, false, 0L);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    void internalShutdownOperation() {
        this.initiateCloseTLSLogic(true);
    }

    @Override
    public void shutdownOperation() {
        this.initiateCloseTLSLogic(false);
    }

    @Override
    public void closeTLSIgnoreTcp(boolean doNotWriteToChannel) {
        this.immediateTLSClose(doNotWriteToChannel);
    }

    @Override
    public void closeTCPOnly() {
        super.closeTCPOnly();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FlushResult flush() {
        FlushResult result = FlushResult.NOT_AVAILABLE;
        try {
            this.writeLock.lock();
            result = this.completeFlush(false);
        }
        finally {
            this.writeLock.unlock();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wrapFlush(long currentDelayInSeconds) {
        try {
            this.writeLock.lock();
            this.writeLogic(false, true, currentDelayInSeconds);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public long flushTaskInitialDelayInSeconds() {
        return this.source.getCore().getConfig().getFlushTaskInitialDelayInSeconds();
    }

    public long flushTaskDelayLimitInSeconds() {
        return this.source.getCore().getConfig().getFlushTaskDelayLimitInSeconds();
    }

    public long partialFlushDelayAdditionInSeconds() {
        return 1L;
    }

    public long nothingFlushedDelayAdditionInSeconds() {
        return 2L;
    }

    @Override
    public boolean isTLSUsed() {
        return true;
    }
}

