/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp;

import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.TLSCommunicationChannel;

public class TLSCloseState {
    private static ESLLogger logger = ESLLogger.getLogger(TLSCloseState.class);
    private CloseInitiator initiator;
    private boolean receivedNotTimeoutTriggeredClose;
    private boolean readDisabled;
    private boolean timeoutTriggered;
    private TimeoutCloseState timeoutCloseState;
    private TLSCommunicationChannel tlsChannel;

    TLSCloseState(TLSCommunicationChannel tlsChannel) {
        this.tlsChannel = tlsChannel;
        this.initiator = CloseInitiator.NONE;
        this.receivedNotTimeoutTriggeredClose = false;
        this.readDisabled = false;
        this.timeoutTriggered = false;
        this.timeoutCloseState = TimeoutCloseState.NO_TIMEOUT;
    }

    public void disableRead() {
        this.readDisabled = true;
        if (logger.isDebugEnabled()) {
            logger.debug("%s Disabled read!", this.tlsChannel.getConnectionIdStr());
        }
    }

    public boolean isReadDisabled() {
        return this.readDisabled;
    }

    synchronized void receivedNotTimeoutTriggeredClose() {
        this.receivedNotTimeoutTriggeredClose = true;
    }

    private boolean initiatedBy(CloseInitiator initiatorOfChoice) {
        boolean retValue;
        boolean bl = retValue = this.initiator == CloseInitiator.NONE;
        if (retValue) {
            this.initiator = initiatorOfChoice;
            logger.info("%s TLSCloseInitiated by %s!", this.tlsChannel.getConnectionIdStr(), initiatorOfChoice.name());
        }
        return retValue;
    }

    synchronized boolean initiatedByOtherException() {
        return this.initiatedBy(CloseInitiator.OTHER_EXCEPTION);
    }

    synchronized boolean initiatedByIOException() {
        return this.initiatedBy(CloseInitiator.IO_EXCEPTION);
    }

    synchronized boolean initiatedBySSLException() {
        return this.initiatedBy(CloseInitiator.SSL_EXCEPTION);
    }

    synchronized boolean initiateByLocal() {
        return this.initiatedBy(CloseInitiator.LOCAL);
    }

    synchronized boolean initiateByRemote() {
        return this.initiatedBy(CloseInitiator.REMOTE);
    }

    synchronized boolean alreadyReceivedNotTimeoutTriggeredClose() {
        return this.receivedNotTimeoutTriggeredClose;
    }

    synchronized boolean wasInitiatedByRemote() {
        return this.initiator == CloseInitiator.REMOTE;
    }

    synchronized boolean wasInitiatedByLocal() {
        return this.initiator == CloseInitiator.LOCAL;
    }

    synchronized String getInitiatorStr() {
        return this.initiator.name();
    }

    synchronized boolean triggerTimeout() {
        if (!this.timeoutTriggered) {
            this.timeoutTriggered = true;
            return true;
        }
        return false;
    }

    synchronized void receivedTimeoutClose() {
        if (this.timeoutCloseState == TimeoutCloseState.NO_TIMEOUT) {
            this.timeoutCloseState = TimeoutCloseState.TIMEOUT_RECEIVED;
        }
    }

    synchronized TimeoutCloseState doTimeoutCloseLogic() {
        TimeoutCloseState retValue = this.timeoutCloseState;
        if (this.timeoutCloseState == TimeoutCloseState.TIMEOUT_RECEIVED) {
            this.timeoutCloseState = TimeoutCloseState.FLUSH_TASK_TRIGGERED;
        }
        return retValue;
    }

    public static enum TimeoutCloseState {
        NO_TIMEOUT,
        TIMEOUT_RECEIVED,
        FLUSH_TASK_TRIGGERED;

    }

    public static enum CloseInitiator {
        NONE,
        LOCAL,
        REMOTE,
        SSL_EXCEPTION,
        IO_EXCEPTION,
        OTHER_EXCEPTION;

    }
}

