/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp;

import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.CloseTask;
import at.mrdevelopment.toolkit.tcp.TCPCommunicationChannel;
import at.mrdevelopment.toolkit.tcp.TCPCore;
import at.mrdevelopment.toolkit.tcp.TLSCommunicationChannel;
import at.mrdevelopment.toolkit.tcp.tasks.InternalTask;
import at.mrdevelopment.toolkit.tcp.tasks.WriteTask;
import java.net.InetSocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public class TCPSource {
    private static final ESLLogger logger = ESLLogger.getLogger(TCPSource.class);
    private final TCPCore core;
    private final TCPCommunicationChannel channel;

    public TCPSource(TCPCore core, TCPCommunicationChannel channel) {
        this.core = core;
        this.channel = channel;
    }

    public TCPCore getCore() {
        return this.core;
    }

    public TCPCommunicationChannel getChannel() {
        return this.channel;
    }

    public int getLocalPort() {
        InetSocketAddress address = null;
        if (this.channel.getReadableChannel() instanceof SocketChannel) {
            address = (InetSocketAddress)((SocketChannel)this.channel.getReadableChannel()).socket().getLocalSocketAddress();
        } else if (this.channel.getReadableChannel() instanceof ServerSocketChannel) {
            address = (InetSocketAddress)((ServerSocketChannel)((Object)this.channel.getReadableChannel())).socket().getLocalSocketAddress();
        } else {
            logger.error("Was unable to retrieve local port, channel type not valid.");
        }
        return address != null ? address.getPort() : -1;
    }

    public void submit(byte[] dataArray, int dataLengthInBytes) {
        this.core.submit(new WriteTask(this.channel, dataArray, dataLengthInBytes));
    }

    public void submit(InternalTask task) {
        this.core.submit(task);
    }

    public void submitClose() {
        if (this.channel instanceof TLSCommunicationChannel) {
            TLSCommunicationChannel tempChannel = (TLSCommunicationChannel)this.channel;
            tempChannel.initiateCloseTLSLogic(false);
        } else {
            this.core.submit(new CloseTask(this.channel));
        }
    }
}

