/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp;

import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.BaseTCPChannel;
import at.mrdevelopment.toolkit.tcp.ProtocolStrategyFactory;
import at.mrdevelopment.toolkit.tcp.TCPCommunicationChannel;
import at.mrdevelopment.toolkit.tcp.TCPConnectionParameters;
import at.mrdevelopment.toolkit.tcp.TCPCore;
import at.mrdevelopment.toolkit.tcp.extern.TCPCoreConfig;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;

public class TCPServerChannel
extends BaseTCPChannel {
    private static ESLLogger logger = ESLLogger.getLogger(TCPServerChannel.class);
    private ServerSocketChannel channel;
    private ProtocolStrategyFactory strategyFactory;
    private TCPCoreConfig config;
    private TCPConnectionParameters connectionParametersForAcceptedConnections;

    private TCPServerChannel(TCPCoreConfig config, ProtocolStrategyFactory strategyFactory, TCPConnectionParameters connectionParametersForAcceptedConnections) {
        this.config = config;
        this.strategyFactory = strategyFactory;
        this.connectionParametersForAcceptedConnections = connectionParametersForAcceptedConnections;
        this.initializeChannel();
    }

    public boolean bind(String addressToListenOn, int portToListenOn) {
        boolean bindSuccessful = false;
        SocketAddress address = this.createAddress(addressToListenOn, portToListenOn);
        try {
            this.channel.socket().bind(address);
            bindSuccessful = true;
        }
        catch (IllegalArgumentException iae) {
            logger.error("The SocketAddress type is not supported.");
            logger.logException(iae);
        }
        catch (SecurityException se) {
            logger.error("Lisening on port %d, not allowed by security manager.", portToListenOn);
        }
        catch (IOException ioe) {
            logger.error("The socket bind operation failed.");
            logger.logException(ioe);
        }
        return bindSuccessful;
    }

    private SocketAddress createAddress(String addressToListenOn, int portToListenOn) {
        InetSocketAddress address = null;
        try {
            address = new InetSocketAddress(addressToListenOn.equals("*") ? null : InetAddress.getByName(addressToListenOn), portToListenOn);
        }
        catch (SecurityException se) {
            logger.error("The security manager does not allow resolving of hostname = ", addressToListenOn);
            logger.logException(se);
        }
        catch (UnknownHostException uhe) {
            logger.error("No IP address could be found for the hostname=", addressToListenOn);
            logger.logException(uhe);
        }
        return address;
    }

    public TCPCommunicationChannel accept(TCPCore tcpCore) {
        TCPCommunicationChannel tcpChannel = null;
        try {
            SocketChannel newSocketChannel = this.channel.accept();
            TCPConnectionParameters parametersOfChoice = TCPConnectionParameters.BASIC_TCP;
            if (this.config.isTLSForced() || this.connectionParametersForAcceptedConnections.useTls()) {
                TCPConnectionParameters tCPConnectionParameters = parametersOfChoice = this.connectionParametersForAcceptedConnections.useTls() ? this.connectionParametersForAcceptedConnections : TCPConnectionParameters.TCP_TLS_AS_SERVER;
            }
            if ((tcpChannel = tcpCore.createTCPCommunicationChannel(this.config, parametersOfChoice, newSocketChannel)) != null) {
                tcpChannel.setProtocolStrategy(this.strategyFactory.createNew());
            }
        }
        catch (SecurityException se) {
            this.logSecurityException(se);
        }
        catch (AsynchronousCloseException ace) {
            logger.info("Connection was closed by another thread.");
        }
        catch (ClosedChannelException cce) {
            logger.info("Trying to operate on a closed channel.");
        }
        catch (IOException ioe) {
            logger.error("Got I/O exception trying to accept a connection.");
            logger.logExceptionIfDebugEnabled(ioe);
            this.baseClose(this.channel);
        }
        return tcpChannel;
    }

    private void logSecurityException(SecurityException se) {
        InetSocketAddress localAddress = (InetSocketAddress)this.channel.socket().getLocalSocketAddress();
        if (localAddress != null) {
            logger.error("The security manager does not seem to allow the acceptance of remote TCP connections to: %s:%d.", localAddress.getHostName(), localAddress.getPort());
            logger.logException(se);
        }
    }

    @Override
    public boolean creationSuccessful() {
        return this.channel != null;
    }

    protected void initializeChannel() {
        try {
            this.channel = ServerSocketChannel.open();
            try {
                this.channel.configureBlocking(false);
            }
            catch (IOException ioe) {
                logger.error("Problem configuring socket channel.");
                logger.logExceptionIfDebugEnabled(ioe);
            }
        }
        catch (IOException ioe) {
            logger.logException(ioe);
        }
    }

    @Override
    protected void register(Selector selector) throws ClosedChannelException {
        this.key = this.channel.register(selector, 16, this);
    }

    @Override
    public void shutdownOperation() {
        this.baseClose(this.channel);
    }

    public static TCPServerChannel createTCPServerChannel(TCPCoreConfig config, ProtocolStrategyFactory strategyFactory, TCPConnectionParameters connectionParametersForAcceptedChannels) {
        return new TCPServerChannel(config, strategyFactory, connectionParametersForAcceptedChannels);
    }
}

