/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp;

import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.ConnectionEstablished;
import at.mrdevelopment.toolkit.tcp.TCPChannel;
import at.mrdevelopment.toolkit.tcp.TCPCommunicationChannel;
import at.mrdevelopment.toolkit.tcp.TCPCore;
import at.mrdevelopment.toolkit.tcp.TCPServerChannel;
import at.mrdevelopment.toolkit.tcp.tasks.ReadTask;
import at.mrdevelopment.toolkit.tcp.tasks.WriteTask;
import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class TCPSelector
implements Runnable {
    private static ESLLogger logger = ESLLogger.getLogger(TCPSelector.class);
    private volatile boolean hasStopped = false;
    private Selector selector;
    private volatile boolean stopExecution = false;
    private TCPCore tcpCore;
    private volatile boolean enableNonTLSConnectionRemoval;
    private List<TCPCommunicationChannel> connectionsToInitiate = Collections.synchronizedList(new LinkedList());

    public TCPSelector(TCPCore tcpCore) throws IOException {
        this.tcpCore = tcpCore;
        this.selector = this.openSelector();
        this.enableNonTLSConnectionRemoval = false;
    }

    private boolean doSelection() {
        boolean selectionFailed = true;
        try {
            this.selector.select(this.tcpCore.getConfig().getSelectionTimeout());
            selectionFailed = false;
        }
        catch (IOException ioe) {
            logger.error("Got I/O error when doing selection.");
            logger.logExceptionIfDebugEnabled(ioe);
        }
        catch (ClosedSelectorException cse) {
            logger.error("Got ClosedSelectorException when selecting.");
            logger.logExceptionIfDebugEnabled(cse);
        }
        return selectionFailed;
    }

    private void handleSelectionKeys() {
        Set<SelectionKey> keys = this.selector.selectedKeys();
        Iterator<SelectionKey> iterator = keys.iterator();
        long taskCreationTime = System.currentTimeMillis();
        while (iterator.hasNext()) {
            SelectionKey key = iterator.next();
            iterator.remove();
            try {
                TCPChannel channel;
                if (!key.isValid()) continue;
                if (key.isAcceptable()) {
                    channel = (TCPServerChannel)key.attachment();
                    TCPCommunicationChannel newChannel = ((TCPServerChannel)channel).accept(this.tcpCore);
                    if (newChannel == null) continue;
                    this.tcpCore.register(newChannel);
                    newChannel.doAfterWasAccepted(this.tcpCore, this.selector);
                    continue;
                }
                if (key.isConnectable()) {
                    channel = (TCPCommunicationChannel)key.attachment();
                    if (channel.finishConnecting(this.selector) == ConnectionEstablished.YES) {
                        channel.doAfterSuccesfullyConnected(this.tcpCore);
                        continue;
                    }
                    channel.doAfterConnectAttemptFailed(this.tcpCore);
                    continue;
                }
                if (key.isReadable()) {
                    channel = (TCPCommunicationChannel)key.attachment();
                    channel.removeInterestOp(1);
                    this.tcpCore.submit(new ReadTask((TCPCommunicationChannel)channel, taskCreationTime));
                    continue;
                }
                if (!key.isWritable()) continue;
                channel = (TCPCommunicationChannel)key.attachment();
                this.tcpCore.submit(new WriteTask((TCPCommunicationChannel)channel));
            }
            catch (Exception e) {
                logger.error("Got exception handling selection keys!");
                logger.logException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleConnectionsToInitiate() {
        List<TCPCommunicationChannel> list = this.connectionsToInitiate;
        synchronized (list) {
            Iterator<TCPCommunicationChannel> it = this.connectionsToInitiate.iterator();
            while (it.hasNext()) {
                try {
                    TCPCommunicationChannel channel = it.next();
                    ConnectionEstablished retValue = channel.connect(this.selector);
                    if (retValue == ConnectionEstablished.YES) {
                        channel.doAfterSuccesfullyConnected(this.tcpCore);
                    } else if (retValue == ConnectionEstablished.ERROR) {
                        channel.doAfterConnectAttemptFailed(this.tcpCore);
                    }
                    it.remove();
                }
                catch (Exception e) {
                    logger.logException(e);
                }
            }
        }
    }

    private ArrayList<SelectionKey> createArrayListFrom(Set<SelectionKey> keys) {
        ArrayList<SelectionKey> copyOfKeySet = null;
        try {
            copyOfKeySet = new ArrayList<SelectionKey>(this.selector.keys());
        }
        catch (Exception e) {
            logger.logExceptionIfDebugEnabled(e);
        }
        return copyOfKeySet;
    }

    private void checkForConnectionTimeouts() {
        long currentTime = System.currentTimeMillis();
        ArrayList<SelectionKey> copyOfKeySet = null;
        for (int idx = 0; idx < 3 && (copyOfKeySet = this.createArrayListFrom(this.selector.keys())) == null; ++idx) {
        }
        if (copyOfKeySet != null) {
            for (SelectionKey key : copyOfKeySet) {
                try {
                    if (!(key.attachment() instanceof TCPCommunicationChannel)) continue;
                    TCPCommunicationChannel channel = (TCPCommunicationChannel)key.attachment();
                    channel.checkForConnectionTimeoutAndHandle(currentTime);
                }
                catch (Exception e) {
                    logger.logException(e);
                }
            }
        }
    }

    private void removeNonTLSConnectionsIfNecessary() {
        int[] connectionIds;
        if (this.enableNonTLSConnectionRemoval && (connectionIds = this.tcpCore.nonTLSConnectionIds()) != null) {
            for (int idx = 0; idx < connectionIds.length; ++idx) {
                TCPCommunicationChannel tempChannel = this.tcpCore.getChannelBy(connectionIds[idx]);
                if (tempChannel == null) continue;
                tempChannel.shutdownOperation();
            }
        }
    }

    private boolean hasStopped() {
        return this.hasStopped;
    }

    private Selector openSelector() throws IOException {
        Selector selector = null;
        selector = Selector.open();
        return selector;
    }

    public void addConnectionToEstablish(TCPCommunicationChannel channel) {
        this.connectionsToInitiate.add(channel);
    }

    public void register(TCPChannel channel) {
        channel.registerWith(this.selector);
    }

    @Override
    public void run() {
        logger.info("TCP-Selector started.");
        if (this.selector == null) {
            this.hasStopped = true;
            return;
        }
        while (!this.stopExecution && !this.doSelection()) {
            this.handleSelectionKeys();
            this.handleConnectionsToInitiate();
            this.checkForConnectionTimeouts();
            this.removeNonTLSConnectionsIfNecessary();
        }
        try {
            this.selector.close();
        }
        catch (IOException ioe) {
            logger.error("Got I/O error closing selector.");
            logger.logExceptionIfDebugEnabled(ioe);
        }
        this.hasStopped = true;
        logger.info("TCP-Selector stopped.");
    }

    public void stopExecution() {
        logger.info("TCP-Selector stopping execution.");
        this.stopExecution = true;
        while (!this.hasStopped()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    void enableNonTLSConnectionRemoval() {
        this.enableNonTLSConnectionRemoval = true;
    }

    void disableNonTLSConnectionRemoval() {
        this.enableNonTLSConnectionRemoval = false;
    }
}

