/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp;

import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.TCPWriteQueueElement;
import at.mrdevelopment.toolkit.tcp.scheduling.TCPTaskLevel;
import java.nio.ByteBuffer;

public class TCPDefaultWriteQueueElement
implements TCPWriteQueueElement {
    private static ESLLogger logger = ESLLogger.getLogger(TCPDefaultWriteQueueElement.class);
    public final byte[] packetData;
    public final int filledBytes;
    public int transfered;

    public TCPDefaultWriteQueueElement(byte[] packetData, int filledBytes) {
        this.packetData = packetData;
        this.filledBytes = filledBytes;
        this.transfered = 0;
    }

    @Override
    public boolean transferTo(ByteBuffer buffer) {
        if (!buffer.hasRemaining()) {
            logger.warn("TCP channel output buffer is full!!! If this happens it means that the previous transfer has not yet been completed.");
            return false;
        }
        int toTransfer = this.filledBytes - this.transfered;
        if (buffer.remaining() >= toTransfer) {
            buffer.put(this.packetData, this.transfered, toTransfer);
            logger.info("Transfered = %d", toTransfer);
            return true;
        }
        int bufferSpace = buffer.remaining();
        buffer.put(this.packetData, this.transfered, bufferSpace);
        this.transfered += bufferSpace;
        logger.info("Not enough space in the output buffer for whole packet. Transfered = %d", bufferSpace);
        return false;
    }

    @Override
    public TCPTaskLevel getTaskLevel() {
        return TCPTaskLevel.NORMAL;
    }

    @Override
    public boolean isClose() {
        return false;
    }
}

