/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp;

import at.mrdevelopment.toolkit.Shutdownable;
import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.ConnectionIdSet;
import at.mrdevelopment.toolkit.tcp.DefaultTCPCommunicationChannel;
import at.mrdevelopment.toolkit.tcp.IdManager;
import at.mrdevelopment.toolkit.tcp.TCPChannel;
import at.mrdevelopment.toolkit.tcp.TCPCommunicationChannel;
import at.mrdevelopment.toolkit.tcp.TCPConnectionParameters;
import at.mrdevelopment.toolkit.tcp.TCPSelector;
import at.mrdevelopment.toolkit.tcp.TCPTLSMode;
import at.mrdevelopment.toolkit.tcp.TLSCommunicationChannel;
import at.mrdevelopment.toolkit.tcp.TLSCore;
import at.mrdevelopment.toolkit.tcp.extern.TCPCoreConfig;
import at.mrdevelopment.toolkit.tcp.scheduling.DefaultTCPTaskScheduler;
import at.mrdevelopment.toolkit.tcp.scheduling.SimplisticTCPTaskScheduler;
import at.mrdevelopment.toolkit.tcp.scheduling.TCPTaskScheduler;
import at.mrdevelopment.toolkit.tcp.tasks.FlushTask;
import at.mrdevelopment.toolkit.tcp.tasks.InternalTask;
import at.mrdevelopment.toolkit.tcp.tasks.ReadTask;
import at.mrdevelopment.toolkit.tcp.tasks.WriteTask;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.security.GeneralSecurityException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class TCPCore
implements Shutdownable {
    private static ESLLogger logger = ESLLogger.getLogger(TCPCore.class);
    private static String COULD_NOT_INIT = "Could not initialize TLS v1.2 logic.";
    private static String TLS_SUPPORT = " TLS v1.2 requires Java 1.8. Message: %s!";
    private TCPSelector selector;
    private final IdManager idManager;
    private final ScheduledThreadPoolExecutor flushTaskExecutor;
    private TCPTaskScheduler readScheduler;
    private TCPTaskScheduler writeScheduler;
    private TCPCoreConfig config;
    private TLSCore tlsCore;
    private final ConnectionIdSet nonTLSConnections;

    public TCPCore(TCPCoreConfig config) throws IOException, GeneralSecurityException {
        this.config = config;
        this.idManager = new IdManager();
        this.nonTLSConnections = new ConnectionIdSet();
        int flushExecutorCoreSize = Runtime.getRuntime().availableProcessors() / 4;
        if (Runtime.getRuntime().availableProcessors() % 4 > 0) {
            ++flushExecutorCoreSize;
        }
        this.flushTaskExecutor = new ScheduledThreadPoolExecutor(flushExecutorCoreSize);
        if (config.isTLSDisabled()) {
            this.tlsCore = null;
        } else {
            boolean configWithoutTLS = true;
            try {
                this.tlsCore = new TLSCore(config.getKeyManagers(), config.getTrustManagers());
                configWithoutTLS = false;
            }
            catch (NoSuchAlgorithmException nsae) {
                logger.warn(COULD_NOT_INIT + TLS_SUPPORT, nsae.getMessage());
                logger.logExceptionIfDebugEnabled(nsae);
            }
            catch (NoSuchProviderException nspe) {
                logger.warn(COULD_NOT_INIT + " No security provider found that supports TLS v1.2: %s!", nspe.getMessage());
                logger.logExceptionIfDebugEnabled(nspe);
            }
            catch (KeyManagementException kme) {
                logger.warn(COULD_NOT_INIT + " Key management issue: %s!", kme.getMessage());
                logger.logExceptionIfDebugEnabled(kme);
            }
            if (configWithoutTLS) {
                TCPCoreConfig.Builder builder = new TCPCoreConfig.Builder();
                builder.initFrom(config);
                builder.setTLSParameters(null, null);
                builder.disableTLS();
                this.config = builder.build();
            }
        }
        this.initialize();
    }

    public void addConnectionToEstablish(TCPCommunicationChannel channel) {
        this.selector.addConnectionToEstablish(channel);
    }

    private void initialize() throws IOException {
        int readThreadPoolSize;
        this.selector = new TCPSelector(this);
        if (this.config.autoConfigureWriteThreadPoolSize()) {
            int writeThreadPoolSize = Runtime.getRuntime().availableProcessors();
            this.writeScheduler = new DefaultTCPTaskScheduler(writeThreadPoolSize *= this.config.isTLSDisabled() ? 1 : 2, "WriteTasksDefaultScheduler");
        } else {
            int writeThreadPoolSize = this.config.getWriteThreadPoolSize();
            this.writeScheduler = writeThreadPoolSize == 1 ? new SimplisticTCPTaskScheduler(writeThreadPoolSize, "WriteTasksSimplisticScheduler") : new DefaultTCPTaskScheduler(writeThreadPoolSize, "WriteTasksDefaultScheduler");
        }
        if (this.config.autoConfigureReadThreadPoolSize()) {
            readThreadPoolSize = Runtime.getRuntime().availableProcessors();
            readThreadPoolSize *= this.config.isTLSDisabled() ? 1 : 2;
        } else {
            readThreadPoolSize = this.config.getReadThreadPoolSize();
        }
        this.readScheduler = new SimplisticTCPTaskScheduler(readThreadPoolSize, "ReadTasksSimplisticScheduler");
    }

    TCPCoreConfig getConfig() {
        return this.config;
    }

    public void submit(InternalTask task) {
        this.writeScheduler.addTask(task);
    }

    public void submit(WriteTask task) {
        this.writeScheduler.addTask(task);
    }

    public void submit(ReadTask task) {
        this.readScheduler.addTask(task);
    }

    public void register(TCPChannel channel) {
        this.selector.register(channel);
        if (channel instanceof TCPCommunicationChannel) {
            TCPCommunicationChannel tempChannel = (TCPCommunicationChannel)channel;
            tempChannel.setSource(this);
            tempChannel.setIdentifier(this.idManager.getId(tempChannel));
            this.readScheduler.register(tempChannel);
            this.writeScheduler.register(tempChannel);
            if (!(tempChannel instanceof TLSCommunicationChannel)) {
                this.nonTLSConnections.add(tempChannel.getIdentifier().getId());
            }
        }
    }

    public TCPCommunicationChannel getChannelBy(Integer connId) {
        return this.idManager.getChannelBy(connId);
    }

    void deregister(TCPCommunicationChannel channel) {
        this.idManager.putBack(channel.getIdentifier());
        this.readScheduler.deregister(channel);
        this.writeScheduler.deregister(channel);
        if (!(channel instanceof TLSCommunicationChannel)) {
            this.nonTLSConnections.remove(channel.getIdentifier().getId());
        }
    }

    public void start() {
        Thread selectorThread = new Thread(this.selector);
        selectorThread.setName("TCPCoreSelector");
        selectorThread.start();
    }

    @Override
    public void shutdown() {
        logger.info("Stoping TCPCore.");
        this.readScheduler.shutdown();
        this.writeScheduler.shutdown();
        this.selector.stopExecution();
    }

    public TCPCommunicationChannel createTCPCommunicationChannel(TCPCoreConfig tcpConfig, TCPConnectionParameters parameters) {
        if (tcpConfig.isTLSForced() || parameters.useTls() && !tcpConfig.isTLSDisabled()) {
            TCPTLSMode modeOfChoice = TCPTLSMode.AS_SERVER;
            if (parameters.useTls()) {
                TCPTLSMode tCPTLSMode = modeOfChoice = parameters.tlsAsServer() ? TCPTLSMode.AS_SERVER : TCPTLSMode.AS_CLIENT;
            }
            if (this.tlsCore != null) {
                return new TLSCommunicationChannel(tcpConfig, modeOfChoice, this.tlsCore.createNewEngine());
            }
            logger.error("Could not create TLS communication channel because TLS is disabled!");
            return null;
        }
        return new DefaultTCPCommunicationChannel(tcpConfig);
    }

    public TCPCommunicationChannel createTCPCommunicationChannel(TCPCoreConfig tcpConfig, TCPConnectionParameters parameters, SocketChannel providedChannel) {
        if (tcpConfig.isTLSForced() || parameters.useTls() && !tcpConfig.isTLSDisabled()) {
            TCPTLSMode modeOfChoice = TCPTLSMode.AS_SERVER;
            if (parameters.useTls()) {
                TCPTLSMode tCPTLSMode = modeOfChoice = parameters.tlsAsServer() ? TCPTLSMode.AS_SERVER : TCPTLSMode.AS_CLIENT;
            }
            if (this.tlsCore != null) {
                return new TLSCommunicationChannel(tcpConfig, modeOfChoice, this.tlsCore.createNewEngine(), providedChannel);
            }
            try {
                providedChannel.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            logger.error("Could not create TLS communication channel because TLS is disabled!");
            return null;
        }
        return new DefaultTCPCommunicationChannel(tcpConfig, providedChannel);
    }

    void submit(FlushTask flushTask) {
        this.flushTaskExecutor.schedule(flushTask, flushTask.getDelayInSeconds(), TimeUnit.SECONDS);
    }

    int[] nonTLSConnectionIds() {
        return this.nonTLSConnections.toArray();
    }

    public void enableNonTLSConnectionRemoval() {
        this.selector.enableNonTLSConnectionRemoval();
    }

    public void disableNonTLSConnectionRemoval() {
        this.selector.disableNonTLSConnectionRemoval();
    }
}

