/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp;

public class TCPConnectionParameters {
    public static TCPConnectionParameters BASIC_TCP = new Builder().build();
    public static TCPConnectionParameters TCP_TLS_AS_SERVER = new Builder().useTls().build();
    public static TCPConnectionParameters TCP_TLS_AS_CLIENT = new Builder().useTls().tlsAsClient().build();
    private final boolean tlsAsServer;
    private final boolean useTls;

    private TCPConnectionParameters(Builder builder) {
        this.tlsAsServer = builder.tlsAsServer;
        this.useTls = builder.useTls;
    }

    public boolean tlsAsServer() {
        return this.tlsAsServer;
    }

    public boolean useTls() {
        return this.useTls;
    }

    public static class Builder {
        private boolean tlsAsServer = true;
        private boolean useTls = false;

        public Builder tlsAsServer() {
            this.tlsAsServer = true;
            return this;
        }

        public Builder tlsAsClient() {
            this.tlsAsServer = false;
            return this;
        }

        public Builder useTls() {
            this.useTls = true;
            return this;
        }

        public TCPConnectionParameters build() {
            return new TCPConnectionParameters(this);
        }
    }
}

