/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp;

import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.TCPCommunicationChannel;
import at.mrdevelopment.toolkit.tcp.scheduling.ConnectionId;
import at.mrdevelopment.toolkit.tcp.scheduling.StubId;
import java.util.HashMap;
import java.util.Random;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class IdManager {
    private static ESLLogger logger = ESLLogger.getLogger(IdManager.class);
    private static final int ID_THRESHOLD = 0xFFFFFF;
    private static final int ID_JUMP = 255;
    private Lock managerLock;
    private HashMap<Integer, TCPCommunicationChannel> idToChannelMap = new HashMap(1024);
    private int lastIssuedId = 0;
    private Random random = new Random();

    public IdManager() {
        this.managerLock = new ReentrantLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getLatestIssuedId() {
        int retValue = -1;
        try {
            this.managerLock.lock();
            retValue = this.lastIssuedId;
        }
        finally {
            this.managerLock.unlock();
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionId getId(TCPCommunicationChannel commChannel) {
        StubId newId = null;
        try {
            this.managerLock.lock();
            do {
                this.lastIssuedId += this.random.nextInt(255);
                this.lastIssuedId %= 0xFFFFFF;
            } while (this.idToChannelMap.containsKey(this.lastIssuedId));
            this.idToChannelMap.put(this.lastIssuedId, commChannel);
            newId = new StubId(this.lastIssuedId);
        }
        finally {
            this.managerLock.unlock();
        }
        return newId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putBack(ConnectionId id) {
        try {
            this.managerLock.lock();
            this.idToChannelMap.remove(id.getId());
            if (logger.isDebugEnabled()) {
                logger.debug(this.toString());
            }
        }
        finally {
            this.managerLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TCPCommunicationChannel getChannelBy(Integer connectionId) {
        TCPCommunicationChannel tempChannel = null;
        try {
            this.managerLock.lock();
            tempChannel = this.idToChannelMap.get(connectionId);
        }
        finally {
            this.managerLock.unlock();
        }
        return tempChannel;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("IdManager [usedIdSet=");
        builder.append(this.idToChannelMap);
        builder.append(", lastIssuedId=");
        builder.append(this.lastIssuedId);
        builder.append("]");
        return builder.toString();
    }
}

