/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp;

import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.BaseTCPChannel;
import at.mrdevelopment.toolkit.tcp.ConnectionEstablished;
import at.mrdevelopment.toolkit.tcp.FlushResult;
import at.mrdevelopment.toolkit.tcp.IOLogicEndpoint;
import at.mrdevelopment.toolkit.tcp.SpecialWriteSituation;
import at.mrdevelopment.toolkit.tcp.TCPCommunicationChannel;
import at.mrdevelopment.toolkit.tcp.TCPCore;
import at.mrdevelopment.toolkit.tcp.TCPDefaultWriteQueueElement;
import at.mrdevelopment.toolkit.tcp.TCPEventStrategy;
import at.mrdevelopment.toolkit.tcp.TCPSource;
import at.mrdevelopment.toolkit.tcp.TCPWriteQueueElement;
import at.mrdevelopment.toolkit.tcp.extern.TCPCoreConfig;
import at.mrdevelopment.toolkit.tcp.scheduling.ConnectionId;
import at.mrdevelopment.toolkit.tcp.tasks.FlushTask;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.AsynchronousCloseException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NoConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.nio.channels.UnsupportedAddressTypeException;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public class DefaultTCPCommunicationChannel
extends BaseTCPChannel
implements TCPCommunicationChannel {
    private static ESLLogger logger = ESLLogger.getLogger(DefaultTCPCommunicationChannel.class);
    protected SocketChannel channel;
    protected LinkedList<TCPWriteQueueElement> writeQueue;
    protected TCPEventStrategy protocolStrategy;
    protected Lock writeLock = new ReentrantLock();
    protected Lock readLock = new ReentrantLock();
    protected boolean channelNotReadyToWrite;
    protected ByteBuffer outboundDataBuffer;
    protected ByteBuffer inboundDataBuffer;
    protected TCPSource source;
    private TCPCoreConfig config;
    protected volatile long lastActivityTime;
    private volatile long connectionTimeoutInMs;
    private AtomicBoolean closeEventCallbackDone = new AtomicBoolean(false);
    private SocketAddress targetAddress;
    private ConnectionId identifier;
    private volatile String connIdStr;
    protected IOLogicEndpoint ioEndpoint;

    DefaultTCPCommunicationChannel(TCPCoreConfig config) {
        this(config, IOLogicEndpoint.CHANNEL, true);
    }

    protected DefaultTCPCommunicationChannel(TCPCoreConfig config, IOLogicEndpoint updateIoEndpoint, boolean allocateBuffers) {
        this.init(config, null, updateIoEndpoint, allocateBuffers);
    }

    DefaultTCPCommunicationChannel(TCPCoreConfig config, SocketChannel providedChannel) {
        this(config, providedChannel, IOLogicEndpoint.CHANNEL, true);
    }

    protected DefaultTCPCommunicationChannel(TCPCoreConfig config, SocketChannel providedChannel, IOLogicEndpoint updateIoEndpoint, boolean allocateBuffers) {
        this.init(config, providedChannel, updateIoEndpoint, allocateBuffers);
    }

    private void init(TCPCoreConfig config, SocketChannel providedChannel, IOLogicEndpoint updateIoEndpoint, boolean allocateBuffers) {
        this.config = config;
        this.ioEndpoint = updateIoEndpoint;
        this.initializeChannel(providedChannel);
        this.writeQueue = new LinkedList();
        if (allocateBuffers) {
            this.outboundDataBuffer = ByteBuffer.allocate(config.getOutputBufferSize());
            this.outboundDataBuffer.order(ByteOrder.LITTLE_ENDIAN);
            this.inboundDataBuffer = ByteBuffer.allocate(config.getInputBufferSize());
            this.inboundDataBuffer.order(ByteOrder.LITTLE_ENDIAN);
        }
        this.connectionTimeoutInMs = config.getConnectionTimeout();
        this.lastActivityTime = 0L;
        this.targetAddress = null;
        this.connIdStr = String.format("ConnId = %d.", -1);
    }

    @Override
    public IOLogicEndpoint getIOEndpoint() {
        return this.ioEndpoint;
    }

    @Override
    public void setProtocolStrategy(TCPEventStrategy protocolStrategy) {
        this.protocolStrategy = protocolStrategy;
    }

    @Override
    public TCPEventStrategy getProtocolStrategy() {
        return this.protocolStrategy;
    }

    @Override
    public void setSource(TCPCore tcpCore) {
        this.source = new TCPSource(tcpCore, this);
    }

    @Override
    public TCPSource getSource() {
        return this.source;
    }

    @Override
    public ReadableByteChannel getReadableChannel() {
        return this.channel;
    }

    @Override
    public boolean creationSuccessful() {
        return this.channel != null;
    }

    @Override
    public void doAfterWasAccepted(TCPCore tcpCore, Selector selector) {
        this.lastActivityTime = System.currentTimeMillis();
        try {
            this.key = this.channel.register(selector, 1, this);
            this.protocolStrategy.doAfterWasAccepted(this.source);
        }
        catch (ClosedChannelException e) {
            this.closeTLSIgnoreTcp(true);
            this.closeTCPOnly();
        }
    }

    @Override
    public void doAfterSuccesfullyConnected(TCPCore tcpCore) {
        this.lastActivityTime = System.currentTimeMillis();
        this.protocolStrategy.doAfterSuccesfullyConnected(this.source);
    }

    @Override
    public void doAfterConnectAttemptFailed(TCPCore tcpCore) {
        if (this.lastActivityTime <= 0L) {
            this.lastActivityTime = System.currentTimeMillis();
        }
        this.protocolStrategy.doAfterConnectAttemptFailed(this.source);
    }

    @Override
    public void establishConnection(String remoteAddress, int targetPort, TCPCore core) {
        this.targetAddress = new InetSocketAddress(remoteAddress, targetPort);
        core.addConnectionToEstablish(this);
    }

    @Override
    public ConnectionEstablished finishConnecting(Selector selector) {
        ConnectionEstablished retValue = ConnectionEstablished.ERROR;
        try {
            if (this.channel.finishConnect()) {
                this.key.interestOps(1);
                retValue = ConnectionEstablished.YES;
            } else {
                retValue = ConnectionEstablished.NO;
            }
        }
        catch (NoConnectionPendingException ncpe) {
            this.closeTLSIgnoreTcp(true);
            this.closeTCPOnly();
            logger.error("Tryed to finish establishing a connection but not initiating it beforehand. Indicates a programming error.");
            logger.logException(ncpe);
        }
        catch (AsynchronousCloseException ace) {
            this.closeTLSIgnoreTcp(true);
            this.closeTCPOnly();
        }
        catch (ClosedChannelException cce) {
            this.closeTLSIgnoreTcp(true);
            this.closeTCPOnly();
        }
        catch (IOException ioe) {
            this.closeTLSIgnoreTcp(true);
            this.closeTCPOnly();
        }
        return retValue;
    }

    @Override
    public ConnectionEstablished connect(Selector selector) {
        ConnectionEstablished retValue = ConnectionEstablished.ERROR;
        try {
            if (this.channel.connect(this.targetAddress)) {
                retValue = ConnectionEstablished.YES;
                this.key = this.channel.register(selector, 1, this);
            } else {
                retValue = ConnectionEstablished.NO;
                this.key = this.channel.register(selector, 8, this);
            }
        }
        catch (UnresolvedAddressException uae) {
            this.closeTLSIgnoreTcp(true);
            this.closeTCPOnly();
            logger.error("Could not resolve address, connecting to: [%s]", this.targetAddress);
            logger.logExceptionIfDebugEnabled(uae);
        }
        catch (UnsupportedAddressTypeException uate) {
            this.closeTLSIgnoreTcp(true);
            this.closeTCPOnly();
            logger.error("Address type is not supported: [%s]", this.targetAddress);
            logger.logExceptionIfDebugEnabled(uate);
        }
        catch (SecurityException se) {
            this.closeTLSIgnoreTcp(true);
            this.closeTCPOnly();
            logger.error("Access to remote address not allowed: [%s]", this.targetAddress);
            logger.logExceptionIfDebugEnabled(se);
        }
        catch (IOException ioe) {
            this.closeTLSIgnoreTcp(true);
            this.closeTCPOnly();
            logger.error("Got I/O error initiating connection to: [%s]", this.targetAddress);
            logger.logExceptionIfDebugEnabled(ioe);
        }
        return retValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read() {
        boolean readSuccesful = false;
        try {
            this.readLock.lock();
            readSuccesful = this.protocolStrategy.readAndDecode(this.source);
        }
        catch (Exception e) {
            logger.logException(e);
        }
        finally {
            this.readLock.unlock();
        }
        try {
            this.addInterestOp(1);
        }
        catch (Exception e) {
            logger.logException(e);
        }
        if (!readSuccesful) {
            logger.debug("Closing channel because read was not successful!");
            this.closeTCPOnly();
        } else {
            this.lastActivityTime = System.currentTimeMillis();
            if (logger.isDebugEnabled() && this.protocolStrategy != null) {
                logger.debug("Done read for = %d!", this.protocolStrategy.getApId());
            }
        }
    }

    private void initializeChannel(SocketChannel providedChannel) {
        try {
            this.channel = providedChannel != null ? providedChannel : SocketChannel.open();
            try {
                this.channel.configureBlocking(false);
                this.channel.socket().setReceiveBufferSize(this.config.getInputBufferSize());
                this.channel.socket().setSendBufferSize(this.config.getOutputBufferSize());
                this.channel.socket().setTcpNoDelay(true);
                logger.info("Expected receive buffer size = %d, actual receive buffer size = %d.", this.config.getInputBufferSize(), this.channel.socket().getReceiveBufferSize());
                logger.info("Expected send buffer size = %d, actual send buffer size = %d.", this.config.getOutputBufferSize(), this.channel.socket().getSendBufferSize());
            }
            catch (IOException ioe) {
                logger.error("Problem configuring socket channel.");
                logger.logExceptionIfDebugEnabled(ioe);
            }
        }
        catch (IOException ioe) {
            logger.logException(ioe);
        }
    }

    @Override
    protected void register(Selector selector) throws ClosedChannelException {
    }

    @Override
    public void write() {
        this.write(null, 0, true, SpecialWriteSituation.NONE);
    }

    @Override
    public void write(byte[] data, int dataLengthInBytes, SpecialWriteSituation specialSituation) {
        this.write(data, dataLengthInBytes, false, specialSituation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void write(byte[] dataArray, int dataLengthInBytes, boolean isTriggeredBySelectorWriteEvent, SpecialWriteSituation specialSituation) {
        try {
            this.writeLock.lock();
            if (this.writeQueue.size() > 1) {
                logger.debug("WriteQueueSize = %d.", this.writeQueue.size());
            }
            if (this.channelNotReadyToWrite) {
                logger.debug("channelNotReadyToWrite = true, isTriggeredBySelectorWriteEvent = %b", isTriggeredBySelectorWriteEvent);
            }
            if (this.channelNotReadyToWrite && !isTriggeredBySelectorWriteEvent) {
                if (this.writeQueue.size() < 10) {
                    this.writeQueue.add(new TCPDefaultWriteQueueElement(dataArray, dataLengthInBytes));
                }
            } else {
                if (dataArray != null && this.writeQueue.size() < 10) {
                    this.writeQueue.add(new TCPDefaultWriteQueueElement(dataArray, dataLengthInBytes));
                }
                boolean wholePacketInOutputBuffer = true;
                while (!this.writeQueue.isEmpty()) {
                    TCPWriteQueueElement element = this.writeQueue.peek();
                    if (element.transferTo(this.outboundDataBuffer)) {
                        this.writeQueue.remove();
                        continue;
                    }
                    wholePacketInOutputBuffer = false;
                    break;
                }
                this.outboundDataBuffer.flip();
                int bytesWritten = this.channel.write(this.outboundDataBuffer);
                if (!wholePacketInOutputBuffer || bytesWritten < this.outboundDataBuffer.limit()) {
                    if (logger.isInfoEnabled()) {
                        logger.info("Could not write all the output buffer contents to the channel or the whole packet could not be copied to the output buffer. To write: %d, writen: %d.", this.outboundDataBuffer.limit(), bytesWritten);
                    }
                    this.channelNotReadyToWrite = true;
                    this.addInterestOp(4);
                } else {
                    this.channelNotReadyToWrite = false;
                    this.removeInterestOp(4);
                }
                this.outboundDataBuffer.compact();
            }
        }
        catch (NotYetConnectedException nyce) {
            logger.error("Tried to write to a channel that has not yet been connected.");
        }
        catch (AsynchronousCloseException ace) {
            logger.info("Connection was closed by another thread.");
            this.sendDisconnectEvent();
        }
        catch (ClosedChannelException cce) {
            logger.info("Trying to operate on a closed channel.");
            this.sendDisconnectEvent();
        }
        catch (IOException ioe) {
            logger.logException(ioe);
            this.closeTCPOnly();
        }
        catch (Exception e) {
            logger.logException(e);
            this.closeTCPOnly();
        }
        finally {
            this.writeLock.unlock();
        }
    }

    @Override
    public long getLastActivityTime() {
        return this.lastActivityTime;
    }

    protected void sendDisconnectEvent() {
        boolean callbackDone = this.closeEventCallbackDone.getAndSet(true);
        if (!callbackDone) {
            if (logger.isInfoEnabled()) {
                logger.info("Closing commChannel = %d.", this.identifier != null ? this.identifier.getId() : -1);
            }
            if (this.protocolStrategy != null) {
                this.protocolStrategy.detectedDisconnect(this);
            }
            if (this.source != null) {
                this.source.getCore().deregister(this);
            }
        }
    }

    @Override
    public boolean isClosed() {
        return this.closeEventCallbackDone.get();
    }

    @Override
    public boolean canConnect() {
        return this.channel.isOpen() && !this.channel.isConnected() && !this.channel.isConnectionPending();
    }

    @Override
    public boolean isConnected() {
        return this.channel.isOpen() && this.channel.isConnected();
    }

    @Override
    public boolean isConnectionPending() {
        return this.channel.isConnectionPending();
    }

    private boolean hasConnectionTimedOut(long currentTime) {
        long tempTime = this.lastActivityTime;
        long timeout = this.connectionTimeoutInMs;
        if (timeout > 0L && tempTime > 0L) {
            if (tempTime >= currentTime) {
                return false;
            }
            return currentTime - tempTime > timeout;
        }
        return false;
    }

    @Override
    public void checkForConnectionTimeoutAndHandle(long currentTime) {
        if (this.hasConnectionTimedOut(currentTime)) {
            if (logger.isInfoEnabled()) {
                if (this.identifier != null) {
                    logger.info("Connection with ID = %d, has timed out and will be closed!", (int)this.identifier.getId());
                } else {
                    logger.info("Connection without an identifier timed out!");
                }
            }
            this.internalShutdownOperation();
        }
    }

    @Override
    public ConnectionId getIdentifier() {
        return this.identifier;
    }

    @Override
    public void setIdentifier(ConnectionId identifier) {
        this.identifier = identifier;
        this.connIdStr = String.format("ConnId = %d.", (int)identifier.getId());
    }

    protected String getConnectionIdStr() {
        return this.connIdStr;
    }

    @Override
    public int getApId() {
        if (this.protocolStrategy != null) {
            return this.protocolStrategy.getApId();
        }
        return -1;
    }

    @Override
    public void setConnectionTimeout(long newConnectionTimeout) {
        this.connectionTimeoutInMs = newConnectionTimeout;
        this.lastActivityTime = System.currentTimeMillis();
    }

    @Override
    public ByteBuffer getInboundDataBuffer() {
        return this.inboundDataBuffer;
    }

    void internalShutdownOperation() {
        this.closeTCPOnly();
    }

    @Override
    public void shutdownOperation() {
        this.closeTCPOnly();
    }

    public void closeTLSIgnoreTcp(boolean doNotWriteToChannel) {
    }

    public void closeTCPOnly() {
        super.baseClose(this.channel);
        this.sendDisconnectEvent();
    }

    @Override
    public FlushResult flush() {
        return FlushResult.NOT_AVAILABLE;
    }

    @Override
    public void submitFlushTask(FlushTask newFlushTask) {
        this.source.getCore().submit(newFlushTask);
    }

    @Override
    public boolean isTLSUsed() {
        return false;
    }
}

