/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.tcp;

import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.tcp.TCPChannel;
import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.IllegalBlockingModeException;
import java.nio.channels.IllegalSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

public abstract class BaseTCPChannel
implements TCPChannel {
    private static ESLLogger logger = ESLLogger.getLogger(BaseTCPChannel.class);
    protected SelectionKey key;
    protected Lock interestOpLock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addInterestOp(int op) {
        try {
            this.interestOpLock.lock();
            this.key.interestOps(this.key.interestOps() | op);
        }
        catch (Exception e) {
            logger.logExceptionIfDebugEnabled(e);
        }
        finally {
            this.interestOpLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeInterestOp(int op) {
        try {
            this.interestOpLock.lock();
            this.key.interestOps(this.key.interestOps() & ~op);
        }
        catch (Exception e) {
            logger.logExceptionIfDebugEnabled(e);
        }
        finally {
            this.interestOpLock.unlock();
        }
    }

    @Override
    public abstract boolean creationSuccessful();

    @Override
    public SelectionKey registerWith(Selector selector) {
        try {
            this.register(selector);
        }
        catch (ClosedSelectorException cse) {
            logger.error("The selector with which we are trying to register is already closed.");
            logger.logExceptionIfDebugEnabled(cse);
        }
        catch (IllegalBlockingModeException ibme) {
            logger.error("The channel is in blocking mode.");
            logger.logExceptionIfDebugEnabled(ibme);
        }
        catch (IllegalSelectorException ise) {
            logger.error("The selector does not match with the channel.");
            logger.logExceptionIfDebugEnabled(ise);
        }
        catch (CancelledKeyException cke) {
            logger.error("Trying to register a channel, whose key has previouslly been canceled, but not yet removed by the select operation.");
            logger.logExceptionIfDebugEnabled(cke);
        }
        catch (IllegalArgumentException iae) {
            logger.error("Trying to register an operation not supported by this channel.");
            logger.logExceptionIfDebugEnabled(iae);
        }
        catch (ClosedChannelException cce) {
            logger.error("The channel being registered is already closed.");
            logger.logExceptionIfDebugEnabled(cce);
        }
        return this.key;
    }

    protected void baseClose(Closeable channel) {
        if (this.key != null) {
            this.key.cancel();
        }
        if (channel != null) {
            try {
                channel.close();
            }
            catch (IOException closeIoe) {
                logger.logException(closeIoe);
            }
        }
    }

    protected abstract void register(Selector var1) throws ClosedChannelException;
}

