/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.string;

public class Levenshtein {
    public static int distance(String a, String b) {
        a = a.toLowerCase();
        b = b.toLowerCase();
        int[] costs = new int[b.length() + 1];
        for (int j = 0; j < costs.length; ++j) {
            costs[j] = j;
        }
        for (int i = 1; i <= a.length(); ++i) {
            costs[0] = i;
            int nw = i - 1;
            for (int j = 1; j <= b.length(); ++j) {
                int cj = Math.min(1 + Math.min(costs[j], costs[j - 1]), a.charAt(i - 1) == b.charAt(j - 1) ? nw : nw + 1);
                nw = costs[j];
                costs[j] = cj;
            }
        }
        return costs[b.length()];
    }

    public static int percentage(int distance, String a, String b) {
        int length = Math.max(a.length(), b.length());
        float percentage = ((float)length - (float)distance) / (float)length * 100.0f;
        return Math.round(percentage);
    }
}

