/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.string;

import at.mrdevelopment.toolkit.options.converter.ConversionException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.WordUtils;

public enum Conversion {
    NONE,
    DEFAULT{

        @Override
        public String convert(String value) throws ConversionException {
            if (value != null) {
                return value.trim();
            }
            return value;
        }
    }
    ,
    TO_UPPER_CASE{

        @Override
        public String convert(String value) throws ConversionException {
            if (value != null) {
                return StringUtils.upperCase((String)value);
            }
            return value;
        }
    }
    ,
    TO_LOWER_CASE{

        @Override
        public String convert(String value) throws ConversionException {
            if (value != null) {
                return StringUtils.lowerCase((String)value);
            }
            return value;
        }
    }
    ,
    STRIP_LEADING_ZEROS{

        @Override
        public String convert(String value) throws ConversionException {
            if (value != null) {
                return StringUtils.stripStart((String)value, (String)"0");
            }
            return value;
        }
    }
    ,
    REPLACE_COMMA_WITH_DOT{

        @Override
        public String convert(String value) throws ConversionException {
            if (value != null) {
                return StringUtils.replace((String)value, (String)",", (String)".");
            }
            return value;
        }
    }
    ,
    REPLACE_UNDERSCORE_WITH_WHITESPACE{

        @Override
        public String convert(String value) throws ConversionException {
            if (value != null) {
                return StringUtils.replace((String)value, (String)"_", (String)" ");
            }
            return value;
        }
    }
    ,
    DELETE_WHITESPACES{

        @Override
        public String convert(String value) throws ConversionException {
            if (value != null) {
                return StringUtils.deleteWhitespace((String)value);
            }
            return value;
        }
    }
    ,
    STRIP_WHITESPACES{

        @Override
        public String convert(String value) throws ConversionException {
            if (value != null) {
                return StringUtils.strip((String)value);
            }
            return value;
        }
    }
    ,
    CAPITALIZE{

        @Override
        public String convert(String value) throws ConversionException {
            if (value != null) {
                return StringUtils.capitalize((String)value);
            }
            return value;
        }
    }
    ,
    CAPITALIZE_ALL_WORDS{

        @Override
        public String convert(String value) throws ConversionException {
            if (value != null) {
                return WordUtils.capitalize((String)value);
            }
            return value;
        }
    }
    ,
    INITIALS{

        @Override
        public String convert(String value) throws ConversionException {
            if (value != null) {
                return WordUtils.initials((String)value);
            }
            return value;
        }
    }
    ,
    SWAP_CASE{

        @Override
        public String convert(String value) throws ConversionException {
            if (value != null) {
                return WordUtils.swapCase((String)value);
            }
            return value;
        }
    }
    ,
    UNCAPITALIZE{

        @Override
        public String convert(String value) throws ConversionException {
            if (value != null) {
                return StringUtils.uncapitalize((String)value);
            }
            return value;
        }
    }
    ,
    TO_BATMAN{

        @Override
        public String convert(String value) throws ConversionException {
            if (value == null || value.length() < 3) {
                return "To the bat mobile, Robin!";
            }
            StringBuilder builder = new StringBuilder();
            for (int index = 0; index < value.length(); ++index) {
                builder.append("na ");
            }
            builder.append("batman!!");
            return builder.toString();
        }
    };


    public String convert(String value) throws ConversionException {
        return value;
    }

    public static Conversion fromString(String name) {
        if (name != null && !name.isEmpty()) {
            name = name.toUpperCase();
            for (Conversion conversion : Conversion.values()) {
                String conversionName = conversion.name();
                if (!conversionName.equals(name) && !conversionName.replaceAll("_", "").equals(name)) continue;
                return conversion;
            }
        }
        return DEFAULT;
    }
}

