/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.security;

import com.google.common.base.Charsets;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Random;
import org.apache.commons.codec.binary.Base64;

public class Password {
    private static final String SSHA = "{SSHA}";
    private static final int DEFAULT_SALT_SIZE = 8;
    private static Random random = new SecureRandom();
    private String saltedHash;

    public Password(String saltedHash) throws IllegalArgumentException {
        if (!saltedHash.startsWith(SSHA)) {
            throw new IllegalArgumentException("Hash not prefixed by {SSHA}; is it really a salted hash?");
        }
        if (saltedHash.length() <= 26) {
            throw new IllegalArgumentException("Hash is too short; we found no salt!");
        }
        this.saltedHash = saltedHash;
    }

    public static Password createFromPlainPassword(String password) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        String saltedHash = Password.getSaltedPassword(password);
        return new Password(saltedHash);
    }

    public String getSaltedHash() {
        return this.saltedHash;
    }

    public byte[] getPasswordHash() throws IllegalArgumentException, UnsupportedEncodingException {
        byte[] digest = this.getChallenge();
        byte[] hash = new byte[20];
        for (int i = 0; i < 20; ++i) {
            hash[i] = digest[i];
        }
        return hash;
    }

    public byte[] getSalt() throws IllegalArgumentException, UnsupportedEncodingException {
        byte[] digest = this.getChallenge();
        byte[] salt = new byte[digest.length - 20];
        for (int i = 20; i < digest.length; ++i) {
            salt[i - 20] = digest[i];
        }
        return salt;
    }

    public boolean verify(String password) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        byte[] passwordHash = this.getPasswordHash();
        byte[] salt = this.getSalt();
        MessageDigest digest = MessageDigest.getInstance("SHA");
        digest.update(password.getBytes());
        byte[] hash = digest.digest(salt);
        return Arrays.equals(passwordHash, hash);
    }

    private byte[] getChallenge() throws UnsupportedEncodingException {
        return Base64.decodeBase64((byte[])this.saltedHash.substring(SSHA.length()).getBytes(Charsets.UTF_8));
    }

    private static String getSaltedPassword(String password) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        byte[] salt = new byte[8];
        random.nextBytes(salt);
        return Password.getSaltedPassword(password, salt);
    }

    private static String getSaltedPassword(String password, byte[] salt) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        int i;
        MessageDigest digest = MessageDigest.getInstance("SHA");
        digest.update(password.getBytes());
        byte[] hash = digest.digest(salt);
        byte[] all = new byte[hash.length + salt.length];
        for (i = 0; i < hash.length; ++i) {
            all[i] = hash[i];
        }
        for (i = 0; i < salt.length; ++i) {
            all[hash.length + i] = salt[i];
        }
        byte[] base64 = Base64.encodeBase64((byte[])all);
        return SSHA + new String(base64, Charsets.UTF_8);
    }
}

