/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.reflection;

import java.lang.reflect.Constructor;

public class ConstructorResolver {
    public static Constructor<?> getCompatibleConstructor(Class<?> clazz, Class<?>[] parameterTypes) {
        Constructor<?>[] constructors = clazz.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            if (constructors[i].getParameterTypes().length != (parameterTypes != null ? parameterTypes.length : 0)) continue;
            Class<?>[] constructorTypes = constructors[i].getParameterTypes();
            boolean isCompatible = true;
            for (int j = 0; j < (parameterTypes != null ? parameterTypes.length : 0); ++j) {
                if (constructorTypes[j].isAssignableFrom(parameterTypes[j]) || !constructorTypes[j].isPrimitive() || ConstructorResolver.isAssignablePrimitiveToBoxed(constructorTypes[j], parameterTypes[j])) continue;
                isCompatible = false;
                break;
            }
            if (!isCompatible) continue;
            return constructors[i];
        }
        return null;
    }

    private static boolean isAssignablePrimitiveToBoxed(Class<?> primitive, Class<?> boxed) {
        if (primitive.equals(Boolean.TYPE)) {
            return boxed.equals(Boolean.class);
        }
        if (primitive.equals(Byte.TYPE)) {
            return boxed.equals(Byte.class);
        }
        if (primitive.equals(Character.TYPE)) {
            return boxed.equals(Character.class);
        }
        if (primitive.equals(Double.TYPE)) {
            return boxed.equals(Double.class);
        }
        if (primitive.equals(Float.TYPE)) {
            return boxed.equals(Float.class);
        }
        if (primitive.equals(Integer.TYPE)) {
            return boxed.equals(Integer.class);
        }
        if (primitive.equals(Long.TYPE)) {
            return boxed.equals(Long.class);
        }
        if (primitive.equals(Short.TYPE)) {
            return boxed.equals(Short.class);
        }
        return false;
    }
}

