/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.pdf;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.xml.SerializeException;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXResult;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;
import org.w3c.dom.Document;

public class PDFSerializer {
    private final XMLToolkit xmlToolkit = new XMLToolkit();
    private final FopFactory fopFactory = FopFactory.newInstance();

    public void transformAndConvertDOMToPDF(Source xsltSource, Source xmlSource, File pdfFile) throws SerializeException, IOException {
        DOMResult result = new DOMResult();
        this.xmlToolkit.transform(xsltSource, xmlSource, result);
        this.convertDOMToPDF((Document)result.getNode(), pdfFile);
    }

    public void convertDOMToPDF(Document xslfoDoc, File pdfFile) throws SerializeException, IOException {
        OutputStream out = null;
        try {
            FOUserAgent foUserAgent = this.fopFactory.newFOUserAgent();
            out = new FileOutputStream(pdfFile);
            out = new BufferedOutputStream(out);
            Fop fop = this.fopFactory.newFop("application/pdf", foUserAgent, out);
            DOMSource src = new DOMSource(xslfoDoc);
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            this.xmlToolkit.transform(src, res);
        }
        catch (FOPException exc) {
            try {
                throw new SerializeException(exc);
            }
            catch (Throwable throwable) {
                StreamUtils.close(out);
                throw throwable;
            }
        }
        StreamUtils.close(out);
    }
}

