/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.os.linux;

import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.os.linux.ProcessOutputReader;
import at.mrdevelopment.toolkit.os.linux.SmartDiskAttribute;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SmartDiskMonitor {
    static ESLLogger logger = ESLLogger.getLogger(SmartDiskMonitor.class);
    private static final String SMART_DISK_ATTRIBUTES_SCRIPT = "/bin/esl/smartDiskAttributes.sh";

    public static List<SmartDiskAttribute> getSmartDiskAttributes() {
        Collection<String> scriptOutput = SmartDiskMonitor.executeSmartDiskMonitorScriptAndReadOutput();
        ArrayList header = null;
        ArrayList<SmartDiskAttribute> attributes = new ArrayList<SmartDiskAttribute>();
        if (scriptOutput != null) {
            for (String line : scriptOutput) {
                line = StringUtils.trim((String)line);
                ArrayList split = Lists.newArrayList((Iterable)Splitter.on((String)" ").split((CharSequence)line));
                if (header == null) {
                    header = split;
                    continue;
                }
                if (header.size() != split.size()) continue;
                LinkedHashMap<String, String> attribute = new LinkedHashMap<String, String>();
                for (int index = 0; index < header.size(); ++index) {
                    attribute.put((String)header.get(index), ((String)split.get(index)).trim());
                }
                attributes.add(new SmartDiskAttribute(attribute));
            }
        }
        return attributes;
    }

    private static Collection<String> executeSmartDiskMonitorScriptAndReadOutput() {
        if (new File(SMART_DISK_ATTRIBUTES_SCRIPT).exists()) {
            try {
                Process process = Runtime.getRuntime().exec(SMART_DISK_ATTRIBUTES_SCRIPT);
                ProcessOutputReader reader = new ProcessOutputReader(process.getInputStream());
                reader.start();
                process.waitFor();
                reader.shutdown();
                if (process.exitValue() == 0 && reader.getLines().size() > 0) {
                    return reader.getLines();
                }
                return null;
            }
            catch (Exception exc) {
                logger.info("Error parsing disk header information: %s", exc.getMessage());
                logger.logException(exc);
            }
        }
        return null;
    }
}

