/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.os.linux;

import at.mrdevelopment.toolkit.StreamUtils;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArrayList;

public class ProcessOutputReader
extends Thread {
    static ESLLogger logger = ESLLogger.getLogger(ProcessOutputReader.class);
    private final InputStream stream;
    private final Collection<String> lines;
    private BufferedReader bufferedReader;

    public ProcessOutputReader(InputStream stream) {
        this.stream = stream;
        this.lines = new CopyOnWriteArrayList<String>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InputStreamReader reader = new InputStreamReader(this.stream);
        this.bufferedReader = new BufferedReader(reader);
        try {
            String infoLine;
            while ((infoLine = this.bufferedReader.readLine()) != null) {
                this.lines.add(infoLine);
            }
        }
        catch (IOException exc) {
            logger.logExceptionIfDebugEnabled(exc);
        }
        finally {
            StreamUtils.close(this.bufferedReader);
            this.bufferedReader = null;
        }
    }

    public void shutdown() {
        if (this.bufferedReader != null) {
            StreamUtils.close(this.bufferedReader);
        }
    }

    public Collection<String> getLines() {
        return new ArrayList<String>(this.lines);
    }
}

