/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.os.linux;

import at.mrdevelopment.toolkit.authentication.Authenticator;
import at.mrdevelopment.toolkit.authentication.Role;
import at.mrdevelopment.toolkit.authentication.UserId;
import at.mrdevelopment.toolkit.http.RequestUser;
import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;

public class LinuxPWAuthAuthenticator
implements Authenticator {
    static ESLLogger logger = ESLLogger.getLogger(LinuxPWAuthAuthenticator.class);

    protected boolean checkPassword(String username, String password) throws Exception {
        ProcessBuilder builder = new ProcessBuilder("sudo", "../password/pwauth");
        Process process = builder.start();
        OutputStreamWriter stream = new OutputStreamWriter(process.getOutputStream());
        stream.write(username);
        stream.write("\n");
        stream.write(password);
        stream.write("\n");
        stream.flush();
        int returnValue = process.waitFor();
        logger.info("pwauth return value was %d", returnValue);
        return returnValue == 0;
    }

    protected boolean isInGroup(String username, String groupname) throws IOException, InterruptedException {
        ProcessBuilder builder = new ProcessBuilder("groups", username);
        Process process = builder.start();
        BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        String groupLine = reader.readLine();
        process.waitFor();
        String[] groups = null;
        groups = groupLine.contains(":") ? groupLine.split(":")[1].split(" ") : groupLine.split(" ");
        for (String group : groups) {
            if (!group.equalsIgnoreCase(groupname)) continue;
            return true;
        }
        return false;
    }

    @Override
    public UserId authorize(String username, String password) {
        try {
            if (!this.checkPassword(username, password)) {
                return UserId.NONE;
            }
            if (this.isInGroup(username, "admin")) {
                return new RequestUser(Role.ADMIN, username);
            }
            if (this.isInGroup(username, "esl")) {
                return new RequestUser(Role.USER, username);
            }
        }
        catch (Exception exc) {
            logger.logException(exc);
        }
        return UserId.NONE;
    }
}

