/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.os.linux;

import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.os.linux.LinuxHardwareInfo;
import at.mrdevelopment.toolkit.os.linux.ProcessOutputReader;
import at.mrdevelopment.toolkit.os.linux.SmartDiskMonitor;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.util.HashMap;
import java.util.List;
import javax.management.MBeanServer;
import org.apache.commons.io.FileUtils;

public class LinuxHardwareInfoLoader {
    static ESLLogger logger = ESLLogger.getLogger(LinuxHardwareInfoLoader.class);
    private static final File MEMINFO_FILE = new File("/proc/meminfo");
    private static final String CPU_TEMP_SCRIPT = "/bin/esl/temperature.sh";
    private static final String CPU_TEMP_SCRIPT_FORMAT = "/bin/esl/temperature.sh %d";

    public static synchronized LinuxHardwareInfo load() throws IOException, InterruptedException {
        long totalMemory = 0L;
        long freeMemory = 0L;
        try {
            List readLines = FileUtils.readLines((File)MEMINFO_FILE);
            for (String line : readLines) {
                if (line.startsWith("MemTotal")) {
                    totalMemory = LinuxHardwareInfoLoader.parseMemInfo(line);
                    continue;
                }
                if (!line.startsWith("MemFree")) continue;
                freeMemory = LinuxHardwareInfoLoader.parseMemInfo(line);
            }
        }
        catch (IOException exc) {
            logger.info("Could not get memory information: %s", exc.getMessage());
            logger.logException(exc);
        }
        MBeanServer mbsc = ManagementFactory.getPlatformMBeanServer();
        OperatingSystemMXBean osMBean = ManagementFactory.newPlatformMXBeanProxy(mbsc, "java.lang:type=OperatingSystem", OperatingSystemMXBean.class);
        double averageSystemLoad = osMBean.getSystemLoadAverage();
        int numberOfCores = osMBean.getAvailableProcessors();
        averageSystemLoad = averageSystemLoad > 1.0 ? 1.0 : (averageSystemLoad /= (double)numberOfCores);
        averageSystemLoad *= 100.0;
        averageSystemLoad = (double)Math.round(averageSystemLoad * 100.0) / 100.0;
        HashMap<String, String> temperatures = new HashMap<String, String>();
        int unavailableTemperatures = 0;
        if (new File(CPU_TEMP_SCRIPT).exists()) {
            for (int coreIndex = 0; coreIndex < numberOfCores; ++coreIndex) {
                try {
                    Process process = Runtime.getRuntime().exec(String.format(CPU_TEMP_SCRIPT_FORMAT, coreIndex));
                    ProcessOutputReader reader = new ProcessOutputReader(process.getInputStream());
                    reader.start();
                    process.waitFor();
                    if (reader.getLines().size() <= 0) continue;
                    temperatures.put(String.format("Core %d", coreIndex), String.format("%s \u00b0C", reader.getLines().iterator().next()));
                    continue;
                }
                catch (Exception exc) {
                    logger.info("Error parsing sensor information: %s", exc.getMessage());
                    logger.logException(exc);
                    temperatures.put(String.format("Core %d", coreIndex), "N/A");
                    ++unavailableTemperatures;
                }
            }
        } else {
            unavailableTemperatures = numberOfCores;
        }
        if (unavailableTemperatures == numberOfCores) {
            temperatures.clear();
        }
        return new LinuxHardwareInfo(totalMemory, freeMemory, averageSystemLoad, numberOfCores, temperatures, SmartDiskMonitor.getSmartDiskAttributes());
    }

    private static long parseMemInfo(String line) {
        String[] split = line.split(" ");
        if (split.length > 1) {
            return Long.parseLong(split[split.length - 2]);
        }
        return 0L;
    }
}

