/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.os.linux;

import at.mrdevelopment.toolkit.log.ESLLogger;
import at.mrdevelopment.toolkit.os.linux.SmartDiskAttribute;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class LinuxHardwareInfo {
    static ESLLogger logger = ESLLogger.getLogger(LinuxHardwareInfo.class);
    private final long totalMemory;
    private final long freeMemory;
    private final double averageSystemLoad;
    private final int numberOfCores;
    private final Map<String, String> temperatures;
    private final List<SmartDiskAttribute> smartDiskAttributes;

    public LinuxHardwareInfo(long totalMemory, long freeMemory, double averageSystemLoad, int numberOfCores, Map<String, String> temperatures, List<SmartDiskAttribute> smartDiskAttributes) {
        this.totalMemory = totalMemory;
        this.freeMemory = freeMemory;
        this.averageSystemLoad = averageSystemLoad;
        this.numberOfCores = numberOfCores;
        this.temperatures = temperatures;
        this.smartDiskAttributes = smartDiskAttributes;
    }

    public long getTotalMemory() {
        return this.totalMemory;
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }

    public long getUsedMemory() {
        return this.totalMemory - this.freeMemory;
    }

    public double getAverageSystemLoad() {
        return this.averageSystemLoad;
    }

    public int getNumberOfCores() {
        return this.numberOfCores;
    }

    public boolean isTemperatureAvailable() {
        return this.temperatures.size() > 0;
    }

    public Map<String, String> getTemperatures() {
        return this.temperatures;
    }

    public boolean isSmartDiskAttributesAvailable() {
        return this.smartDiskAttributes.size() > 0;
    }

    public List<SmartDiskAttribute> getSmartDiskAttributes() {
        return Collections.unmodifiableList(this.smartDiskAttributes);
    }
}

