/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.os.linux;

import at.mrdevelopment.toolkit.InitializationException;
import at.mrdevelopment.toolkit.appliance.disk.DiskState;
import at.mrdevelopment.toolkit.appliance.disk.SMARTAttribute;
import at.mrdevelopment.toolkit.file.FileUtils;
import at.mrdevelopment.toolkit.os.FileSystem;
import at.mrdevelopment.toolkit.os.FileSystemInfo;
import at.mrdevelopment.toolkit.os.linux.LinuxHardwareInfo;
import at.mrdevelopment.toolkit.os.linux.SmartDiskAttribute;
import at.mrdevelopment.toolkit.xml.XMLSerializer;
import at.mrdevelopment.toolkit.xml.XMLToolkit;
import java.util.Map;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class HardwareInfoXMLSerializer
implements XMLSerializer<LinuxHardwareInfo> {
    private final XMLToolkit xmlToolkit = new XMLToolkit();
    private DiskState referenceDiskState;

    private Element toXML(Document document, LinuxHardwareInfo hardwareInfo, FileSystemInfo fileSystemInfo, DiskState diskState) {
        if (this.referenceDiskState == null) {
            this.referenceDiskState = diskState;
        }
        Element element = document.createElement("hardware-info");
        this.toXML(document, element, hardwareInfo, fileSystemInfo, diskState);
        return element;
    }

    public Document toXML(LinuxHardwareInfo hardwareInfo, FileSystemInfo fileSystemInfo, DiskState diskState) {
        if (this.referenceDiskState == null) {
            this.referenceDiskState = diskState;
        }
        Document document = this.xmlToolkit.newDocument();
        document.appendChild(this.toXML(document, hardwareInfo, fileSystemInfo, diskState));
        return document;
    }

    private void toXML(Document document, Element element, LinuxHardwareInfo hardwareInfo, FileSystemInfo fileSystemInfo, DiskState diskState) {
        Element memoryElement = document.createElement("memory");
        memoryElement.setAttribute("total", FileUtils.toReadableSize(hardwareInfo.getTotalMemory(), 1));
        memoryElement.setAttribute("free", FileUtils.toReadableSize(hardwareInfo.getFreeMemory(), 1));
        double freePercent = (double)hardwareInfo.getFreeMemory() / (double)hardwareInfo.getTotalMemory() * 100.0;
        memoryElement.setAttribute("free-percent", String.format("%.2f", freePercent));
        memoryElement.setAttribute("used", FileUtils.toReadableSize(hardwareInfo.getUsedMemory(), 1));
        double usedPercent = (double)hardwareInfo.getUsedMemory() / (double)hardwareInfo.getTotalMemory() * 100.0;
        memoryElement.setAttribute("used-percent", String.format("%.2f", usedPercent));
        element.appendChild(memoryElement);
        Element fileSystemsElement = document.createElement("file-systems");
        if (fileSystemInfo != null) {
            for (FileSystem fs : fileSystemInfo.getFileSystems()) {
                Element fileSystemElement = document.createElement("file-system");
                fileSystemElement.setAttribute("name", fs.getLabel());
                fileSystemElement.setAttribute("total", FileUtils.toReadableSize(fs.getTotalSpaceInBytes()));
                fileSystemElement.setAttribute("free", FileUtils.toReadableSize(fs.getFreeSpaceInBytes()));
                double freeFsPercent = (double)fs.getFreeSpaceInBytes() / (double)fs.getTotalSpaceInBytes() * 100.0;
                fileSystemElement.setAttribute("free-percent", String.format("%.2f", freeFsPercent));
                fileSystemElement.setAttribute("used", FileUtils.toReadableSize(fs.getUsedSpaceInBytes()));
                double usedFsPercent = (double)fs.getUsedSpaceInBytes() / (double)fs.getTotalSpaceInBytes() * 100.0;
                fileSystemElement.setAttribute("used-percent", String.format("%.2f", usedFsPercent));
                fileSystemElement.setAttribute("usable", FileUtils.toReadableSize(fs.getUsableSpaceInBytes()));
                double useableFsPercent = (double)fs.getUsableSpaceInBytes() / (double)fs.getTotalSpaceInBytes() * 100.0;
                fileSystemElement.setAttribute("usable-percent", String.format("%.2f", useableFsPercent));
                fileSystemElement.setAttribute("path", fs.getPath());
                fileSystemsElement.appendChild(fileSystemElement);
            }
        }
        element.appendChild(fileSystemsElement);
        Element cpuInfoElement = document.createElement("cpu-info");
        cpuInfoElement.setAttribute("numberOfCores", String.valueOf(hardwareInfo.getNumberOfCores()));
        cpuInfoElement.setAttribute("systemLoad", String.valueOf(hardwareInfo.getAverageSystemLoad()));
        for (Map.Entry<String, String> entry : hardwareInfo.getTemperatures().entrySet()) {
            Element cpuElement = document.createElement("cpu");
            cpuElement.setAttribute("name", entry.getKey());
            cpuElement.setAttribute("temperature", entry.getValue());
            cpuInfoElement.appendChild(cpuElement);
        }
        element.appendChild(cpuInfoElement);
        if (hardwareInfo.isSmartDiskAttributesAvailable()) {
            Set<String> headerSet = hardwareInfo.getSmartDiskAttributes().get(0).getAttributes().keySet();
            Element smartDiskMonitorHeaders = document.createElement("disk-header-information");
            for (String header : headerSet) {
                Element headerInformationElement = document.createElement("header");
                headerInformationElement.setAttribute("id", header);
                smartDiskMonitorHeaders.appendChild(headerInformationElement);
            }
            element.appendChild(smartDiskMonitorHeaders);
            Element smartDiskMonitorAttributes = document.createElement("disk-attribute-information");
            for (SmartDiskAttribute attribute : hardwareInfo.getSmartDiskAttributes()) {
                Element attributesInformationElement = document.createElement("attributes");
                for (String header : headerSet) {
                    Element attributeInformationElement = document.createElement("attribute");
                    attributeInformationElement.setAttribute("id", header);
                    attributeInformationElement.setAttribute("value", attribute.getAttributes().get(header));
                    attributesInformationElement.appendChild(attributeInformationElement);
                }
                smartDiskMonitorAttributes.appendChild(attributesInformationElement);
            }
            element.appendChild(smartDiskMonitorAttributes);
        }
        if (diskState != null) {
            Element diskStateElement = document.createElement("disk-state");
            diskStateElement.setAttribute("smart-tool-name", diskState.getToolName());
            diskStateElement.setAttribute("smart-tool-version", diskState.getToolVersion());
            Element diskInformationElement = document.createElement("disk-information");
            for (Map.Entry<String, String> entry : diskState.getDiskInformation().entrySet()) {
                Element diskInformationEntryElement = document.createElement("disk-information-entry");
                diskInformationEntryElement.setAttribute("id", entry.getKey());
                diskInformationEntryElement.setAttribute("value", entry.getValue());
                diskInformationElement.appendChild(diskInformationEntryElement);
            }
            diskStateElement.appendChild(diskInformationElement);
            Element smartAttributesElement = document.createElement("smart-attributes");
            for (SMARTAttribute smartAttribute : diskState.getSmartAttributes().values()) {
                Element smartAttributeElement = document.createElement("smart-attribute");
                smartAttributeElement.setAttribute("id", smartAttribute.getId().toString());
                smartAttributeElement.setAttribute("name", smartAttribute.getName());
                smartAttributeElement.setAttribute("value", smartAttribute.getValue().toString());
                smartAttributeElement.setAttribute("delta", Long.toString(this.referenceDiskState.getSmartAttributes().get(smartAttribute.getId()).getValue() - smartAttribute.getValue()));
                smartAttributesElement.appendChild(smartAttributeElement);
            }
            diskStateElement.appendChild(smartAttributesElement);
            element.appendChild(diskStateElement);
        }
    }
}

