/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.os;

import at.mrdevelopment.toolkit.file.FileUtils;
import java.io.File;

public class FileSystem {
    private final File root;
    private final String label;

    public FileSystem(File root, String label) {
        this.root = root;
        this.label = label;
    }

    public String getPath() {
        return this.root.getAbsolutePath();
    }

    public File getFile() {
        return this.root;
    }

    public String getLabel() {
        return this.label != null ? this.label : this.getFile().toString();
    }

    public long getTotalSpaceInBytes() {
        return this.root.getTotalSpace();
    }

    public long getFreeSpaceInBytes() {
        return this.root.getUsableSpace();
    }

    public long getUsableSpaceInBytes() {
        return this.root.getUsableSpace();
    }

    public long getUsedSpaceInBytes() {
        return this.root.getTotalSpace() - this.root.getUsableSpace();
    }

    public String toString() {
        return String.format("%s (%s): total=%s, free=%s, usable=%s", this.getLabel(), this.getFile().toString(), FileUtils.toReadableSize(this.getTotalSpaceInBytes()), FileUtils.toReadableSize(this.getFreeSpaceInBytes()), FileUtils.toReadableSize(this.getUsableSpaceInBytes()));
    }
}

