/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.os;

import at.mrdevelopment.toolkit.log.ESLLogger;
import java.io.File;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;

public class ArchitectureUtils {
    static ESLLogger logger = ESLLogger.getLogger(ArchitectureUtils.class);
    public static final boolean IS_ARCH_ARM = StringUtils.containsIgnoreCase((String)SystemUtils.OS_ARCH, (String)"arm");
    public static final boolean IS_64_BIT = StringUtils.containsIgnoreCase((String)SystemUtils.OS_ARCH, (String)"64");

    public static void addLibraryPath(String pathToAdd) throws Exception {
        if (!ArchitectureUtils.tryLoadingToUserPath(pathToAdd)) {
            File libDirectory = new File(pathToAdd);
            if (libDirectory.exists()) {
                FileUtils.copyDirectory((File)new File(pathToAdd), (File)new File("."));
            } else {
                logger.info("No matching serial communication (RXTX) library found.");
            }
        }
    }

    private static boolean tryLoadingToUserPath(String pathToAdd) {
        try {
            String[] paths;
            Field usrPathsField = ClassLoader.class.getDeclaredField("usr_paths");
            usrPathsField.setAccessible(true);
            for (String path : paths = (String[])usrPathsField.get(null)) {
                if (!path.equals(pathToAdd)) continue;
                return true;
            }
            String[] newPaths = Arrays.copyOf(paths, paths.length + 1);
            newPaths[newPaths.length - 1] = pathToAdd;
            usrPathsField.set(null, newPaths);
            return true;
        }
        catch (Exception exc) {
            logger.debug("Could not append library to user path: %s", exc.getMessage());
            return false;
        }
    }
}

