/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.options.optionvalue;

import at.mrdevelopment.toolkit.options.OptionException;
import at.mrdevelopment.toolkit.options.optionvalue.XSLOptionValue;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Scanner;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class TextOptionValue
implements XSLOptionValue<String> {
    private static final String LINE_BREAK = "<br />";
    private final Element element;
    private String stringValue;

    public TextOptionValue(Element element) {
        this.element = element;
        this.stringValue = this.parseStringValue();
    }

    private String parseStringValue() {
        Element dummyElement = (Element)this.element.cloneNode(true);
        NodeList childNodes = dummyElement.getChildNodes();
        ArrayList<Node> nodesToRemove = new ArrayList<Node>();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Node item = childNodes.item(index);
            if (!item.getNodeName().contains("xsl:attribute")) continue;
            nodesToRemove.add(item);
        }
        for (Node node : nodesToRemove) {
            dummyElement.removeChild(node);
        }
        try {
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            StringWriter buffer = new StringWriter();
            transformer.setOutputProperty("omit-xml-declaration", "yes");
            transformer.transform(new DOMSource(dummyElement), new StreamResult(buffer));
            String value = buffer.toString();
            int start = value.indexOf(">");
            int end = value.lastIndexOf("<");
            value = start + 1 < end - 1 ? value.substring(start + 1, end - 1) : "";
            value = value.replaceAll("\r", "");
            value = value.replace("\n", "");
            return StringUtils.normalizeSpace((String)value);
        }
        catch (TransformerConfigurationException e) {
            e.printStackTrace();
        }
        catch (TransformerException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public void set(String value) throws OptionException {
        this.stringValue = value;
        if (value == null) {
            this.removeText();
        } else {
            this.removeText();
            this.setText(value);
        }
    }

    private void setText(String value) throws OptionException {
        value = this.insertBreaks(value);
        try {
            Element dummyElement = this.createDummyElement(value, true);
            dummyElement = (Element)dummyElement.getElementsByTagName("textOption").item(0);
            Node importedNode = this.element.getOwnerDocument().importNode(dummyElement, true);
            NodeList childNodes = importedNode.getChildNodes();
            ArrayList<Node> nodes = new ArrayList<Node>();
            for (int index = 0; index < childNodes.getLength(); ++index) {
                nodes.add(childNodes.item(index));
            }
            for (Node node : nodes) {
                this.element.appendChild(node);
            }
        }
        catch (Exception exc) {
            throw new OptionException(exc);
        }
    }

    private String insertBreaks(String value) {
        StringBuilder builder = new StringBuilder();
        Scanner scanner = new Scanner(value);
        while (scanner.hasNextLine()) {
            String line = scanner.nextLine();
            builder.append(line);
            if (!scanner.hasNextLine()) continue;
            builder.append(LINE_BREAK);
        }
        return builder.toString();
    }

    private void removeText() {
        NodeList childNodes = this.element.getChildNodes();
        ArrayList<Node> nodesToRemove = new ArrayList<Node>();
        for (int index = 0; index < childNodes.getLength(); ++index) {
            Node item = childNodes.item(index);
            if (item.getNodeName().contains("xsl:attribute")) continue;
            nodesToRemove.add(item);
        }
        for (Node node : nodesToRemove) {
            this.element.removeChild(node);
        }
    }

    private Element createDummyElement(String stringValue, boolean ignoreWhitespace) throws ParserConfigurationException, SAXException, IOException {
        String dummyString = "<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\"><xsl:template match=\"/\"><textOption>" + stringValue + "</textOption></xsl:template></xsl:stylesheet>";
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setIgnoringElementContentWhitespace(ignoreWhitespace);
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document document = builder.parse(new InputSource(new StringReader(dummyString)));
        return document.getDocumentElement();
    }

    @Override
    public String get() throws OptionException {
        return this.stringValue;
    }

    @Override
    public void setValueFromString(String value) throws OptionException {
        this.set(value);
    }

    @Override
    public String getValueAsString() {
        return this.stringValue;
    }

    @Override
    public void setInheritatedValue(String valueAsString) {
    }
}

