/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.options.converter;

import at.mrdevelopment.toolkit.options.converter.ArrayStringConverter;
import at.mrdevelopment.toolkit.options.converter.ConversionException;
import java.awt.Point;

public class PointArrayStringConverter
extends ArrayStringConverter<Point> {
    public PointArrayStringConverter() {
        super(null);
    }

    @Override
    public String convert(Point[] from) {
        if (from == null) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < from.length; ++i) {
            builder.append(String.format("%d,%d", from[i].x, from[i].y));
            if (i == from.length - 1) continue;
            builder.append(" ");
        }
        return builder.toString();
    }

    @Override
    public Point[] reconvert(String to) throws ConversionException {
        if (to == null) {
            throw new ConversionException("Unable to convert null value");
        }
        String replaced = to.replaceAll("\\s*,\\s*", ",");
        String[] splitted = replaced.split("\\s+");
        if (splitted.length == 0) {
            throw new ConversionException(String.format("Unable to parse point from string %s", to));
        }
        Point[] points = new Point[splitted.length];
        for (int i = 0; i < splitted.length; ++i) {
            try {
                String[] stringPoints = splitted[i].split(",");
                if (stringPoints.length != 2) {
                    throw new ConversionException(String.format("Unable to parse point from string %s", to));
                }
                int x = Integer.parseInt(stringPoints[0]);
                int y = Integer.parseInt(stringPoints[1]);
                points[i] = new Point(x, y);
                continue;
            }
            catch (NumberFormatException exc) {
                throw new ConversionException(exc);
            }
        }
        return points;
    }
}

