/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.options.converter;

import at.mrdevelopment.toolkit.options.converter.ConversionException;
import at.mrdevelopment.toolkit.options.converter.Converter;

public class IntegerStringConverter
implements Converter<Integer, String> {
    @Override
    public String convert(Integer integerValue) {
        if (integerValue == null) {
            return null;
        }
        return "" + integerValue;
    }

    @Override
    public Integer reconvert(String stringValue) throws ConversionException {
        if (stringValue == null) {
            throw new ConversionException("Unable to convert from String to Integer: stringValue was null");
        }
        try {
            return Integer.parseInt(stringValue);
        }
        catch (NumberFormatException e) {
            throw new ConversionException("Unable to convert from String to Integer. Original message: " + e.getMessage(), e.getCause());
        }
    }
}

