/*
 * Decompiled with CFR 0.152.
 */
package at.mrdevelopment.toolkit.options.converter;

import at.mrdevelopment.toolkit.options.converter.ConversionException;
import at.mrdevelopment.toolkit.options.converter.Converter;
import java.awt.Font;

public class FontStringConverter
implements Converter<Font, String> {
    private static final String DELIMITER = ";";
    private static final int NUM_PARAMS_IN_STRING_REPRESENTATION = 3;

    @Override
    public String convert(Font fontValue) {
        if (fontValue == null) {
            return null;
        }
        return fontValue.toString() + DELIMITER + fontValue.getStyle() + DELIMITER + fontValue.getSize();
    }

    @Override
    public Font reconvert(String stringValue) throws ConversionException {
        if (stringValue == null) {
            throw new ConversionException("Unable to convert from String to Font: stringValue was null");
        }
        String[] splitValue = stringValue.split(DELIMITER);
        if (splitValue == null || splitValue.length != 3) {
            throw new ConversionException("Unable to convert from String to Font: stringValue can't be interpreted.");
        }
        String fontAsString = splitValue[0];
        try {
            int style = Integer.parseInt(splitValue[1]);
            int size = Integer.parseInt(splitValue[2]);
            if (fontAsString == null) {
                throw new ConversionException("Unable to convert from String to Font: fontAsString was null.");
            }
            Font font = new Font(fontAsString, style, size);
            return font;
        }
        catch (NumberFormatException e) {
            throw new ConversionException("Unable to convert from String to Font.", e.getCause());
        }
    }
}

